/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.api.controllers;

import com.moesif.api.exceptions.APIException;
import com.moesif.api.http.client.HttpCallBack;
import com.moesif.api.http.client.HttpClient;
import com.moesif.api.http.client.HttpContext;
import com.moesif.api.http.client.UnirestClient;
import com.moesif.api.http.response.HttpResponse;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.stream.Collectors;

public abstract class BaseController {
    private static HttpClient clientInstance = null;
    private static Object syncObject = new Object();
    protected HttpCallBack httpCallBack = null;

    public HttpCallBack getHttpCallBack() {
        return this.httpCallBack;
    }

    public void setHttpCallBack(HttpCallBack httpCallBack) {
        this.httpCallBack = httpCallBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient getClientInstance() {
        Object object = syncObject;
        synchronized (object) {
            if (null == clientInstance) {
                clientInstance = UnirestClient.getSharedInstance();
            }
        }
        return clientInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClientInstance(HttpClient client) {
        Object object = syncObject;
        synchronized (object) {
            if (null != client) {
                clientInstance = client;
            }
        }
    }

    protected void validateResponse(HttpResponse response, HttpContext context) throws APIException {
        int responseCode = response.getStatusCode();
        if (responseCode < 200 || responseCode > 206) {
            String responseBody = "";
            try {
                String b = new BufferedReader(new InputStreamReader(response.getRawBody())).lines().collect(Collectors.joining("\n"));
                if (null != b) {
                    responseBody = b.length() > 400 ? b.substring(0, 400) : b;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new APIException("HTTP Response [" + responseCode + "] Not OK: " + responseBody, context);
        }
    }
}

