/*
 * Decompiled with CFR 0.152.
 */
package com.mashape.unirest.request.body;

import com.mashape.unirest.http.utils.MapUtil;
import com.mashape.unirest.request.BaseRequest;
import com.mashape.unirest.request.HttpRequest;
import com.mashape.unirest.request.body.Body;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;

public class MultipartBody
extends BaseRequest
implements Body {
    private List<String> keyOrder = new ArrayList<String>();
    private Map<String, List<Object>> parameters = new HashMap<String, List<Object>>();
    private boolean hasFile;
    private HttpRequest httpRequestObj;

    public MultipartBody(HttpRequest httpRequest) {
        super(httpRequest);
        this.httpRequestObj = httpRequest;
    }

    public MultipartBody field(String name, String value) {
        return this.field(name, value, false);
    }

    public MultipartBody field(String name, Collection<?> collection) {
        for (Object current : collection) {
            boolean isFile = current instanceof File;
            this.field(name, current, isFile);
        }
        return this;
    }

    public MultipartBody field(String name, Object value) {
        return this.field(name, value, false);
    }

    public MultipartBody field(String name, Object value, boolean file) {
        this.keyOrder.add(name);
        List<Object> list = this.parameters.get(name);
        if (list == null) {
            list = new LinkedList<Object>();
        }
        list.add(value);
        this.parameters.put(name, list);
        if (!this.hasFile && file) {
            this.hasFile = true;
        }
        return this;
    }

    public MultipartBody field(String name, File file) {
        return this.field(name, file, true);
    }

    public MultipartBody basicAuth(String username, String password) {
        this.httpRequestObj.basicAuth(username, password);
        return this;
    }

    @Override
    public HttpEntity getEntity() {
        if (this.hasFile) {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            for (String key : this.keyOrder) {
                List<Object> value = this.parameters.get(key);
                for (Object cur : value) {
                    if (cur instanceof File) {
                        builder.addPart(key, (ContentBody)new FileBody((File)cur));
                        continue;
                    }
                    builder.addPart(key, (ContentBody)new StringBody(cur.toString(), ContentType.create((String)ContentType.APPLICATION_FORM_URLENCODED.getMimeType(), (Charset)Charset.forName("UTF-8"))));
                }
            }
            return builder.build();
        }
        try {
            return new UrlEncodedFormEntity(MapUtil.getList(this.parameters), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

