/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaException;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.keyword.ThresholdMixin;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.utils.JsonNodeTypes;
import com.networknt.schema.utils.JsonType;
import java.math.BigDecimal;
import java.math.BigInteger;
import tools.jackson.databind.JsonNode;

public class MaximumValidator
extends BaseKeywordValidator {
    private static final String PROPERTY_EXCLUSIVE_MAXIMUM = "exclusiveMaximum";
    private final boolean excludeEqual;
    private final ThresholdMixin typedMaximum;

    public MaximumValidator(SchemaLocation schemaLocation, final JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.MAXIMUM, schemaNode, schemaLocation, parentSchema, schemaContext);
        if (!schemaNode.isNumber()) {
            throw new SchemaException("maximum value is not a number");
        }
        JsonNode exclusiveMaximumNode = this.getParentSchema().getSchemaNode().get(PROPERTY_EXCLUSIVE_MAXIMUM);
        this.excludeEqual = exclusiveMaximumNode != null && exclusiveMaximumNode.isBoolean() ? exclusiveMaximumNode.booleanValue() : false;
        final String maximumText = schemaNode.asString();
        if ((schemaNode.isLong() || schemaNode.isInt()) && JsonType.INTEGER.toString().equals(this.getNodeFieldType())) {
            final long lm = schemaNode.asLong();
            this.typedMaximum = new ThresholdMixin(){

                @Override
                public boolean crossesThreshold(JsonNode node) {
                    if (node.isBigInteger()) {
                        int compare = node.bigIntegerValue().compareTo(new BigInteger(schemaNode.asString()));
                        return compare > 0 || MaximumValidator.this.excludeEqual && compare == 0;
                    }
                    if (node.isString()) {
                        BigDecimal max = new BigDecimal(maximumText);
                        BigDecimal value = new BigDecimal(node.asString());
                        int compare = value.compareTo(max);
                        return compare > 0 || MaximumValidator.this.excludeEqual && compare == 0;
                    }
                    long val = node.asLong();
                    return lm < val || MaximumValidator.this.excludeEqual && lm == val;
                }

                @Override
                public String thresholdValue() {
                    return String.valueOf(lm);
                }
            };
        } else {
            this.typedMaximum = new ThresholdMixin(){

                @Override
                public boolean crossesThreshold(JsonNode node) {
                    if (schemaNode.isDouble() && schemaNode.doubleValue() == Double.POSITIVE_INFINITY) {
                        return false;
                    }
                    if (schemaNode.isDouble() && schemaNode.doubleValue() == Double.NEGATIVE_INFINITY) {
                        return true;
                    }
                    if (node.isDouble() && node.doubleValue() == Double.NEGATIVE_INFINITY) {
                        return false;
                    }
                    if (node.isDouble() && node.doubleValue() == Double.POSITIVE_INFINITY) {
                        return true;
                    }
                    BigDecimal max = new BigDecimal(maximumText);
                    BigDecimal value = new BigDecimal(node.asString());
                    int compare = value.compareTo(max);
                    return compare > 0 || MaximumValidator.this.excludeEqual && compare == 0;
                }

                @Override
                public String thresholdValue() {
                    return maximumText;
                }
            };
        }
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        if (!JsonNodeTypes.isNumber(node, this.schemaContext.getSchemaRegistryConfig())) {
            return;
        }
        if (this.typedMaximum.crossesThreshold(node)) {
            executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).locale(executionContext.getExecutionConfig().getLocale())).arguments(this.typedMaximum.thresholdValue())).build());
        }
    }
}

