/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.AbstractKeyword;
import com.networknt.schema.keyword.AbstractKeywordValidator;
import com.networknt.schema.keyword.Keyword;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.path.NodePath;
import java.util.Map;
import tools.jackson.databind.JsonNode;

public class NonValidationKeyword
extends AbstractKeyword {
    public NonValidationKeyword(String keyword) {
        super(keyword);
    }

    @Override
    public KeywordValidator newValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        return new Validator(schemaLocation, schemaNode, parentSchema, schemaContext, this);
    }

    private static final class Validator
    extends AbstractKeywordValidator {
        public Validator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext, Keyword keyword) {
            super(keyword, schemaNode, schemaLocation);
            String id = schemaContext.resolveSchemaId(schemaNode);
            String anchor = schemaContext.getDialect().readAnchor(schemaNode);
            String dynamicAnchor = schemaContext.getDialect().readDynamicAnchor(schemaNode);
            if (id != null || anchor != null || dynamicAnchor != null) {
                schemaContext.newSchema(schemaLocation, schemaNode, parentSchema);
            }
            if ("$defs".equals(keyword.getValue()) || "definitions".equals(keyword.getValue())) {
                for (Map.Entry property : schemaNode.properties()) {
                    SchemaLocation location = schemaLocation.append((String)property.getKey());
                    Schema schema = schemaContext.newSchema(location, (JsonNode)property.getValue(), parentSchema);
                    schemaContext.getSchemaReferences().put(location.toString(), schema);
                }
            }
        }

        @Override
        public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        }
    }
}

