/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaException;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.annotation.Annotation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.regex.RegularExpression;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import tools.jackson.databind.JsonNode;

public class PatternPropertiesValidator
extends BaseKeywordValidator {
    public static final String PROPERTY = "patternProperties";
    private final Map<RegularExpression, Schema> schemas = new IdentityHashMap<RegularExpression, Schema>();

    public PatternPropertiesValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.PATTERN_PROPERTIES, schemaNode, schemaLocation, parentSchema, schemaContext);
        if (!schemaNode.isObject()) {
            throw new SchemaException("patternProperties must be an object node");
        }
        for (String name : schemaNode.propertyNames()) {
            RegularExpression pattern = RegularExpression.compile(name, schemaContext);
            this.schemas.put(pattern, schemaContext.newSchema(schemaLocation.append(name), schemaNode.get(name), parentSchema));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        boolean collectAnnotations;
        if (!node.isObject()) {
            return;
        }
        Set matchedInstancePropertyNames = null;
        Iterator fields = node.properties().iterator();
        boolean bl = collectAnnotations = this.hasUnevaluatedPropertiesInEvaluationPath(executionContext) || this.collectAnnotations(executionContext);
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            String name = (String)field.getKey();
            JsonNode n = (JsonNode)field.getValue();
            for (Map.Entry<RegularExpression, Schema> entry : this.schemas.entrySet()) {
                if (!entry.getKey().matches(name)) continue;
                NodePath path = instanceLocation.append(name);
                int currentErrors = executionContext.getErrors().size();
                Schema schema = entry.getValue();
                executionContext.evaluationPathAddLast(schema.getSchemaLocation().getFragment().getElement(-1).toString());
                try {
                    schema.validate(executionContext, n, rootNode, path);
                }
                finally {
                    executionContext.evaluationPathRemoveLast();
                }
                if (currentErrors != executionContext.getErrors().size() || !collectAnnotations) continue;
                if (matchedInstancePropertyNames == null) {
                    matchedInstancePropertyNames = new LinkedHashSet();
                }
                matchedInstancePropertyNames.add(name);
            }
        }
        if (collectAnnotations) {
            executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(matchedInstancePropertyNames != null ? matchedInstancePropertyNames : Collections.emptySet()).build());
        }
    }

    @Override
    public void preloadSchema() {
        this.preloadSchemas(this.schemas.values());
    }
}

