/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.ext.servlet;

import com.noelios.restlet.component.ChildContext;
import com.noelios.restlet.component.ComponentContext;
import com.noelios.restlet.ext.servlet.ServletCall;
import com.noelios.restlet.ext.servlet.ServletContextAdapter;
import com.noelios.restlet.ext.servlet.ServletWarClient;
import com.noelios.restlet.http.HttpServerCall;
import com.noelios.restlet.http.HttpServerHelper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.Route;
import org.restlet.Server;
import org.restlet.VirtualHost;
import org.restlet.data.LocalReference;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.util.Engine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerServlet
extends HttpServlet {
    private static final String APPLICATION_KEY = "org.restlet.application";
    private static final String AUTO_WIRE_KEY = "org.restlet.autoWire";
    private static final String AUTO_WIRE_KEY_DEFAULT = "true";
    private static final String CLIENTS_KEY = "org.restlet.clients";
    private static final String COMPONENT_KEY = "org.restlet.component";
    private static final String NAME_APPLICATION_ATTRIBUTE = "org.restlet.attribute.application";
    private static final String NAME_APPLICATION_ATTRIBUTE_DEFAULT = "com.noelios.restlet.ext.servlet.ServerServlet.application";
    private static final String NAME_COMPONENT_ATTRIBUTE = "org.restlet.attribute.component";
    private static final String NAME_COMPONENT_ATTRIBUTE_DEFAULT = "com.noelios.restlet.ext.servlet.ServerServlet.component";
    private static final String NAME_SERVER_ATTRIBUTE = "org.restlet.attribute.server";
    private static final String NAME_SERVER_ATTRIBUTE_DEFAULT = "com.noelios.restlet.ext.servlet.ServerServlet.server";
    private static final long serialVersionUID = 1L;
    private volatile transient Application application = null;
    private volatile transient Component component = null;
    private volatile transient HttpServerHelper helper = null;

    protected Application createApplication(Context context) {
        Application application = null;
        String applicationClassName = this.getInitParameter(APPLICATION_KEY, null);
        if (applicationClassName != null) {
            try {
                Class<?> targetClass = this.getClass(applicationClassName);
                try {
                    application = (Application)targetClass.getConstructor(Context.class).newInstance(new Object[]{new ServletContextAdapter((Servlet)this, context)});
                }
                catch (NoSuchMethodException e) {
                    this.log("[Noelios Restlet Engine] - The ServerServlet couldn't invoke the constructor of the target class. Please check this class has a constructor with a single parameter of type Context. The empty constructor and the context setter will be used instead.", e);
                    application = (Application)targetClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    ChildContext applicationContext = (ChildContext)application.getContext();
                    Logger logger = applicationContext == null ? context.getLogger() : applicationContext.getLogger();
                    application.setContext((Context)new ChildContext((Restlet)application, (Context)new ServletContextAdapter((Servlet)this, context), logger));
                }
            }
            catch (ClassNotFoundException e) {
                this.log("[Noelios Restlet Engine] - The ServerServlet couldn't find the target class. Please check that your classpath includes " + applicationClassName, e);
            }
            catch (InstantiationException e) {
                this.log("[Noelios Restlet Engine] - The ServerServlet couldn't instantiate the target class. Please check this class has an empty constructor " + applicationClassName, e);
            }
            catch (IllegalAccessException e) {
                this.log("[Noelios Restlet Engine] - The ServerServlet couldn't instantiate the target class. Please check that you have to proper access rights to " + applicationClassName, e);
            }
            catch (NoSuchMethodException e) {
                this.log("[Noelios Restlet Engine] - The ServerServlet couldn't invoke the constructor of the target class. Please check this class has a constructor with a single parameter of Context " + applicationClassName, e);
            }
            catch (InvocationTargetException e) {
                this.log("[Noelios Restlet Engine] - The ServerServlet couldn't instantiate the target class. An exception was thrown while creating " + applicationClassName, e);
            }
        }
        if (application != null) {
            String initParam;
            ChildContext applicationContext = (ChildContext)application.getContext();
            ServletConfig servletConfig = this.getServletConfig();
            Enumeration enum1 = servletConfig.getInitParameterNames();
            while (enum1.hasMoreElements()) {
                initParam = (String)enum1.nextElement();
                applicationContext.getParameters().add(initParam, servletConfig.getInitParameter(initParam));
            }
            enum1 = this.getServletContext().getInitParameterNames();
            while (enum1.hasMoreElements()) {
                initParam = (String)enum1.nextElement();
                applicationContext.getParameters().add(initParam, this.getServletContext().getInitParameter(initParam));
            }
        }
        return application;
    }

    protected HttpServerCall createCall(Server server, HttpServletRequest request, HttpServletResponse response) {
        return new ServletCall(server, request, response);
    }

    protected Component createComponent() {
        String initParam;
        Component component = null;
        String configPath = this.getServletContext().getRealPath("/WEB-INF/restlet.xml");
        File configFile = new File(configPath);
        if (configPath != null && configFile.exists()) {
            component = new Component((Reference)LocalReference.createFileReference((String)configPath));
        } else {
            String componentClassName = this.getInitParameter(COMPONENT_KEY, null);
            if (componentClassName != null) {
                try {
                    Class<?> targetClass = this.getClass(componentClassName);
                    component = (Component)targetClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    this.log("[Noelios Restlet Engine] - The ServerServlet couldn't find the target class. Please check that your classpath includes " + componentClassName, e);
                }
                catch (InstantiationException e) {
                    this.log("[Noelios Restlet Engine] - The ServerServlet couldn't instantiate the target class. Please check this class has an empty constructor " + componentClassName, e);
                }
                catch (IllegalAccessException e) {
                    this.log("[Noelios Restlet Engine] - The ServerServlet couldn't instantiate the target class. Please check that you have to proper access rights to " + componentClassName, e);
                }
            }
            if (component == null) {
                component = new Component();
                component.getStatusService().setEnabled(false);
                String clientProtocolsString = this.getInitParameter(CLIENTS_KEY, null);
                if (clientProtocolsString != null) {
                    String[] clientProtocols;
                    for (String clientProtocol : clientProtocols = clientProtocolsString.split(" ")) {
                        component.getClients().add(Protocol.valueOf((String)clientProtocol));
                    }
                }
            }
        }
        component.getClients().add((Object)this.createWarClient(component.getContext(), this.getServletConfig()));
        ComponentContext componentContext = (ComponentContext)component.getContext();
        ServletConfig servletConfig = this.getServletConfig();
        Enumeration enum1 = servletConfig.getInitParameterNames();
        while (enum1.hasMoreElements()) {
            initParam = (String)enum1.nextElement();
            componentContext.getParameters().add(initParam, servletConfig.getInitParameter(initParam));
        }
        enum1 = this.getServletContext().getInitParameterNames();
        while (enum1.hasMoreElements()) {
            initParam = (String)enum1.nextElement();
            componentContext.getParameters().add(initParam, this.getServletContext().getInitParameter(initParam));
        }
        return component;
    }

    protected HttpServerHelper createServer(HttpServletRequest request) {
        HttpServerHelper result = null;
        Component component = this.getComponent();
        if (component != null) {
            Server server = new Server(component.getContext().createChildContext(), (List)null, request.getLocalAddr(), request.getLocalPort(), (Restlet)component);
            result = new HttpServerHelper(server);
            String uriPattern = request.getContextPath() + request.getServletPath();
            if (this.isDefaultComponent()) {
                if (this.application != null && this.application != null) {
                    this.log("[Noelios Restlet Engine] - Attaching application: " + this.application + " to URI: " + uriPattern);
                    component.getDefaultHost().attach(uriPattern, (Restlet)this.application);
                }
            } else {
                String autoWire = this.getInitParameter(AUTO_WIRE_KEY, AUTO_WIRE_KEY_DEFAULT);
                if (AUTO_WIRE_KEY_DEFAULT.equalsIgnoreCase(autoWire)) {
                    for (Route route : component.getDefaultHost().getRoutes()) {
                        if (route.getTemplate().getPattern() != null && route.getTemplate().getPattern().startsWith(uriPattern)) continue;
                        this.log("[Noelios Restlet Engine] - Attaching restlet: " + route.getNext() + " to URI: " + uriPattern + route.getTemplate().getPattern());
                        route.getTemplate().setPattern(uriPattern + route.getTemplate().getPattern());
                    }
                    for (VirtualHost virtualHost : component.getHosts()) {
                        for (Route route : virtualHost.getRoutes()) {
                            if (route.getTemplate().getPattern() != null && route.getTemplate().getPattern().startsWith(uriPattern)) continue;
                            this.log("[Noelios Restlet Engine] - Attaching restlet: " + route.getNext() + " to URI: " + uriPattern + route.getTemplate().getPattern());
                            route.getTemplate().setPattern(uriPattern + route.getTemplate().getPattern());
                        }
                    }
                }
            }
        }
        return result;
    }

    protected Client createWarClient(Context context, ServletConfig config) {
        return new ServletWarClient(context, config.getServletContext());
    }

    public void destroy() {
        if (this.getComponent() != null && this.getComponent().isStarted()) {
            try {
                this.getComponent().stop();
            }
            catch (Exception e) {
                this.log("Error during the stopping of the Restlet Component", e);
            }
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Application getApplication() {
        Application result = this.application;
        if (result != null) return result;
        Class<ServerServlet> clazz = ServerServlet.class;
        synchronized (ServerServlet.class) {
            if (result != null || !this.isDefaultComponent()) return result;
            String applicationAttributeName = this.getInitParameter(NAME_APPLICATION_ATTRIBUTE, NAME_APPLICATION_ATTRIBUTE_DEFAULT);
            result = (Application)this.getServletContext().getAttribute(applicationAttributeName);
            if (result == null) {
                result = this.createApplication(this.getComponent().getContext());
                this.getServletContext().setAttribute(applicationAttributeName, (Object)result);
            }
            this.application = result;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    protected Class<?> getClass(String className) throws ClassNotFoundException {
        return Engine.classForName((String)className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component getComponent() {
        Component result = this.component;
        if (result != null) return result;
        Class<ServerServlet> clazz = ServerServlet.class;
        synchronized (ServerServlet.class) {
            if (result == null) {
                String componentAttributeName = this.getInitParameter(NAME_COMPONENT_ATTRIBUTE, NAME_COMPONENT_ATTRIBUTE_DEFAULT);
                result = (Component)this.getServletContext().getAttribute(componentAttributeName);
                if (result == null) {
                    result = this.createComponent();
                    this.getServletContext().setAttribute(componentAttributeName, (Object)result);
                }
            }
            this.component = result;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    public String getInitParameter(String name, String defaultValue) {
        String result = this.getServletConfig().getInitParameter(name);
        if (result == null) {
            result = this.getServletConfig().getServletContext().getInitParameter(name);
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HttpServerHelper getServer(HttpServletRequest request) {
        HttpServerHelper result = this.helper;
        if (result != null) return result;
        Class<ServerServlet> clazz = ServerServlet.class;
        synchronized (ServerServlet.class) {
            if (result != null) return result;
            String serverAttributeName = this.getInitParameter(NAME_SERVER_ATTRIBUTE, NAME_SERVER_ATTRIBUTE_DEFAULT);
            result = (HttpServerHelper)this.getServletContext().getAttribute(serverAttributeName);
            if (result == null) {
                result = this.createServer(request);
                this.getServletContext().setAttribute(serverAttributeName, (Object)result);
            }
            this.helper = result;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    public void init() throws ServletException {
        if (this.getComponent() != null && this.getApplication() != null && this.getApplication().isStopped()) {
            try {
                this.getApplication().start();
            }
            catch (Exception e) {
                this.log("Error during the starting of the Restlet Application", e);
            }
        }
    }

    private boolean isDefaultComponent() {
        String configPath = this.getServletContext().getRealPath("/WEB-INF/restlet.xml");
        File configFile = new File(configPath);
        String componentAttributeName = this.getInitParameter(COMPONENT_KEY, null);
        return (configPath == null || !configFile.exists()) && componentAttributeName == null;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpServerHelper helper = this.getServer(request);
        if (helper != null) {
            helper.handle(this.createCall((Server)helper.getHelped(), request, response));
        } else {
            this.log("[Noelios Restlet Engine] - Unable to get the Restlet HTTP server connector. Status code 500 returned.");
            response.sendError(500);
        }
    }
}

