/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.application;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import org.restlet.data.CharacterSet;
import org.restlet.data.Encoding;
import org.restlet.resource.Representation;
import org.restlet.util.ByteUtils;
import org.restlet.util.WrapperRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecodeRepresentation
extends WrapperRepresentation {
    private volatile boolean canDecode;
    private volatile List<Encoding> wrappedEncodings;

    public static List<Encoding> getSupportedEncodings() {
        return Arrays.asList(Encoding.GZIP, Encoding.DEFLATE, Encoding.ZIP, Encoding.IDENTITY);
    }

    public DecodeRepresentation(Representation wrappedRepresentation) {
        super(wrappedRepresentation);
        this.canDecode = DecodeRepresentation.getSupportedEncodings().containsAll(wrappedRepresentation.getEncodings());
        this.wrappedEncodings = new ArrayList<Encoding>();
        this.wrappedEncodings.addAll(wrappedRepresentation.getEncodings());
    }

    public boolean canDecode() {
        return this.canDecode;
    }

    public ReadableByteChannel getChannel() throws IOException {
        if (this.canDecode()) {
            return ByteUtils.getChannel((InputStream)this.getStream());
        }
        return this.getWrappedRepresentation().getChannel();
    }

    private InputStream getDecodedStream(Encoding encoding, InputStream encodedStream) throws IOException {
        InflaterInputStream result = null;
        if (encoding.equals((Object)Encoding.GZIP)) {
            result = new GZIPInputStream(encodedStream);
        } else if (encoding.equals((Object)Encoding.DEFLATE)) {
            result = new InflaterInputStream(encodedStream);
        } else if (encoding.equals((Object)Encoding.ZIP)) {
            ZipInputStream stream = new ZipInputStream(encodedStream);
            if (stream.getNextEntry() != null) {
                result = stream;
            }
        } else if (encoding.equals((Object)Encoding.IDENTITY)) {
            throw new IOException("Decoder unecessary for identity decoding");
        }
        return result;
    }

    public List<Encoding> getEncodings() {
        if (this.canDecode()) {
            return new ArrayList<Encoding>();
        }
        return this.wrappedEncodings;
    }

    public long getSize() {
        long result = -1L;
        if (this.canDecode()) {
            boolean identity = true;
            Iterator<Encoding> iter = this.getEncodings().iterator();
            while (identity && iter.hasNext()) {
                identity = iter.next().equals((Object)Encoding.IDENTITY);
            }
            if (identity) {
                result = this.getWrappedRepresentation().getSize();
            }
        } else {
            result = this.getWrappedRepresentation().getSize();
        }
        return result;
    }

    public InputStream getStream() throws IOException {
        InputStream result = null;
        if (this.canDecode()) {
            result = this.getWrappedRepresentation().getStream();
            for (int i = this.wrappedEncodings.size() - 1; i >= 0; --i) {
                if (this.wrappedEncodings.get(i).equals((Object)Encoding.IDENTITY)) continue;
                result = this.getDecodedStream(this.wrappedEncodings.get(i), result);
            }
        }
        return result;
    }

    public String getText() throws IOException {
        String result = null;
        result = this.canDecode() ? ByteUtils.toString((InputStream)this.getStream(), (CharacterSet)this.getCharacterSet()) : this.getWrappedRepresentation().getText();
        return result;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.canDecode()) {
            ByteUtils.write((InputStream)this.getStream(), (OutputStream)outputStream);
        } else {
            this.getWrappedRepresentation().write(outputStream);
        }
    }

    public void write(WritableByteChannel writableChannel) throws IOException {
        if (this.canDecode()) {
            this.write(ByteUtils.getStream((WritableByteChannel)writableChannel));
        } else {
            this.getWrappedRepresentation().write(writableChannel);
        }
    }
}

