/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.application;

import com.noelios.restlet.http.PreferenceUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import org.restlet.Context;
import org.restlet.Filter;
import org.restlet.data.CharacterSet;
import org.restlet.data.ClientInfo;
import org.restlet.data.Encoding;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.service.MetadataService;
import org.restlet.service.TunnelService;
import org.restlet.util.Engine;

public class TunnelFilter
extends Filter {
    public TunnelFilter(Context context) {
        super(context);
    }

    public int beforeHandle(Request request, Response response) {
        if (this.getTunnelService().isUserAgentTunnel()) {
            this.processUserAgent(request);
        }
        if (this.getTunnelService().isExtensionsTunnel()) {
            this.processExtensions(request);
        }
        if (this.getTunnelService().isQueryTunnel()) {
            this.processQuery(request);
        }
        return 0;
    }

    private Metadata getMetadata(String extension) {
        return this.getMetadataService().getMetadata(extension);
    }

    public MetadataService getMetadataService() {
        return this.getApplication().getMetadataService();
    }

    public TunnelService getTunnelService() {
        return this.getApplication().getTunnelService();
    }

    private boolean processExtensions(Request request) {
        Reference resourceRef;
        TunnelService tunnelService = this.getTunnelService();
        boolean extensionsModified = false;
        Method method = request.getMethod();
        if (tunnelService.isPreferencesTunnel() && (method.equals((Object)Method.GET) || method.equals((Object)Method.HEAD)) && (resourceRef = request.getResourceRef()).hasExtensions()) {
            String extensions;
            boolean languageFound;
            boolean mediaTypeFound;
            boolean characterSetFound;
            boolean encodingFound;
            block9: {
                ClientInfo clientInfo = request.getClientInfo();
                encodingFound = false;
                characterSetFound = false;
                mediaTypeFound = false;
                languageFound = false;
                extensions = resourceRef.getExtensions();
                while (true) {
                    int lastIndexOfPoint = extensions.lastIndexOf(46);
                    String extension = extensions.substring(lastIndexOfPoint + 1);
                    Metadata metadata = this.getMetadata(extension);
                    if (!mediaTypeFound && metadata instanceof MediaType) {
                        this.updateMetadata(clientInfo, metadata);
                        mediaTypeFound = true;
                    } else if (!languageFound && metadata instanceof Language) {
                        this.updateMetadata(clientInfo, metadata);
                        languageFound = true;
                    } else if (!characterSetFound && metadata instanceof CharacterSet) {
                        this.updateMetadata(clientInfo, metadata);
                        characterSetFound = true;
                    } else {
                        if (encodingFound || !(metadata instanceof Encoding)) break block9;
                        this.updateMetadata(clientInfo, metadata);
                        encodingFound = true;
                    }
                    if (lastIndexOfPoint <= 0) break;
                    extensions = extensions.substring(0, lastIndexOfPoint);
                }
                extensions = "";
            }
            if (encodingFound || characterSetFound || mediaTypeFound || languageFound) {
                resourceRef.setExtensions(extensions);
                extensionsModified = true;
            }
        }
        return extensionsModified;
    }

    private boolean processQuery(Request request) {
        TunnelService tunnelService = this.getTunnelService();
        boolean queryModified = false;
        Reference resourceRef = request.getResourceRef();
        if (resourceRef.hasQuery()) {
            String methodName;
            Method tunnelledMethod;
            Form query = resourceRef.getQueryAsForm(null);
            Method method = request.getMethod();
            if (tunnelService.isMethodTunnel() && (tunnelledMethod = Method.valueOf((String)(methodName = query.getFirstValue(tunnelService.getMethodParameter())))) != null && (Method.POST.equals((Object)method) || Method.OPTIONS.equals((Object)tunnelledMethod))) {
                request.setMethod(tunnelledMethod);
                query.removeFirst(tunnelService.getMethodParameter());
                queryModified = true;
            }
            if (tunnelService.isPreferencesTunnel()) {
                String charSetParameter = tunnelService.getCharacterSetParameter();
                String encodingParameter = tunnelService.getEncodingParameter();
                String languageParameter = tunnelService.getLanguageParameter();
                String mediaTypeParameter = tunnelService.getMediaTypeParameter();
                String acceptedCharSet = query.getFirstValue(charSetParameter);
                String acceptedEncoding = query.getFirstValue(encodingParameter);
                String acceptedLanguage = query.getFirstValue(languageParameter);
                String acceptedMediaType = query.getFirstValue(mediaTypeParameter);
                ClientInfo clientInfo = request.getClientInfo();
                Metadata metadata = this.getMetadata(acceptedCharSet);
                if (metadata instanceof CharacterSet) {
                    this.updateMetadata(clientInfo, metadata);
                    query.removeFirst(charSetParameter);
                    queryModified = true;
                }
                if ((metadata = this.getMetadata(acceptedEncoding)) instanceof Encoding) {
                    this.updateMetadata(clientInfo, metadata);
                    query.removeFirst(encodingParameter);
                    queryModified = true;
                }
                if ((metadata = this.getMetadata(acceptedLanguage)) instanceof Language) {
                    this.updateMetadata(clientInfo, metadata);
                    query.removeFirst(languageParameter);
                    queryModified = true;
                }
                if ((metadata = this.getMetadata(acceptedMediaType)) instanceof MediaType) {
                    this.updateMetadata(clientInfo, metadata);
                    query.removeFirst(mediaTypeParameter);
                    queryModified = true;
                }
            }
            if (queryModified) {
                request.getResourceRef().setQuery(query.getQueryString(null));
            }
        }
        return queryModified;
    }

    private void processUserAgent(Request request) {
        URL userAgentPropertiesUrl;
        Map agentAttributes = request.getClientInfo().getAgentAttributes();
        if (agentAttributes != null && (userAgentPropertiesUrl = Engine.getClassLoader().getResource("org/restlet/service/accept.properties")) != null) {
            Form headers = (Form)request.getAttributes().get("org.restlet.http.headers");
            String acceptOld = headers != null ? headers.getFirstValue("Accept") : null;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(userAgentPropertiesUrl.openStream(), CharacterSet.UTF_8.getName()));
                boolean processAcceptHeader = true;
                String line = reader.readLine();
                while (line != null) {
                    String[] keyValue;
                    if (!line.startsWith("#") && (keyValue = line.split(":")).length == 2) {
                        String key = keyValue[0].trim();
                        String value = keyValue[1].trim();
                        if ("acceptNew".equalsIgnoreCase(key)) {
                            if (processAcceptHeader) {
                                ClientInfo clientInfo = new ClientInfo();
                                PreferenceUtils.parseMediaTypes(value, clientInfo);
                                request.getClientInfo().setAcceptedMediaTypes(clientInfo.getAcceptedMediaTypes());
                                break;
                            }
                            processAcceptHeader = true;
                        } else if (processAcceptHeader) {
                            String attribute;
                            processAcceptHeader = "acceptOld".equalsIgnoreCase(key) && value != null && value.length() != 0 ? value.equalsIgnoreCase(acceptOld) : (attribute = (String)agentAttributes.get(key)) != null && attribute.equalsIgnoreCase(value);
                        }
                    }
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private void updateMetadata(ClientInfo clientInfo, Metadata metadata) {
        if (metadata != null) {
            if (metadata instanceof CharacterSet) {
                clientInfo.getAcceptedCharacterSets().clear();
                clientInfo.getAcceptedCharacterSets().add(new Preference((Metadata)((CharacterSet)metadata)));
            } else if (metadata instanceof Encoding) {
                clientInfo.getAcceptedEncodings().clear();
                clientInfo.getAcceptedEncodings().add(new Preference((Metadata)((Encoding)metadata)));
            } else if (metadata instanceof Language) {
                clientInfo.getAcceptedLanguages().clear();
                clientInfo.getAcceptedLanguages().add(new Preference((Metadata)((Language)metadata)));
            } else if (metadata instanceof MediaType) {
                clientInfo.getAcceptedMediaTypes().clear();
                clientInfo.getAcceptedMediaTypes().add(new Preference((Metadata)((MediaType)metadata)));
            }
        }
    }
}

