/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.AtomicTest;
import com.nordstrom.automation.junit.JUnitWatcher;
import com.nordstrom.automation.junit.Run;
import com.nordstrom.automation.junit.RunWatcher;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runners.model.FrameworkMethod;

public class RunAnnouncer
extends RunListener {
    private static final ServiceLoader<RunWatcher> runWatcherLoader;
    private static final Map<Object, AtomicTest> RUNNER_TO_ATOMICTEST;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted(Description description) throws Exception {
        AtomicTest atomicTest = RunAnnouncer.getAtomicTestOf(description);
        ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
        synchronized (serviceLoader) {
            for (RunWatcher watcher : runWatcherLoader) {
                watcher.testStarted(atomicTest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFinished(Description description) throws Exception {
        AtomicTest atomicTest = RunAnnouncer.getAtomicTestOf(description);
        ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
        synchronized (serviceLoader) {
            for (RunWatcher watcher : runWatcherLoader) {
                watcher.testFinished(atomicTest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailure(Failure failure) throws Exception {
        AtomicTest atomicTest = RunAnnouncer.setTestFailure(failure);
        ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
        synchronized (serviceLoader) {
            for (RunWatcher watcher : runWatcherLoader) {
                watcher.testFailure(atomicTest, failure.getException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssumptionFailure(Failure failure) {
        AtomicTest atomicTest = RunAnnouncer.setTestFailure(failure);
        ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
        synchronized (serviceLoader) {
            for (RunWatcher watcher : runWatcherLoader) {
                watcher.testAssumptionFailure(atomicTest, (AssumptionViolatedException)failure.getException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIgnored(Description description) throws Exception {
        AtomicTest atomicTest = RunAnnouncer.getAtomicTestOf(description);
        ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
        synchronized (serviceLoader) {
            for (RunWatcher watcher : runWatcherLoader) {
                watcher.testIgnored(atomicTest);
            }
        }
    }

    static AtomicTest newAtomicTest(Object runner, FrameworkMethod method) {
        AtomicTest atomicTest = new AtomicTest(runner, method);
        RUNNER_TO_ATOMICTEST.put(runner, atomicTest);
        RUNNER_TO_ATOMICTEST.put(atomicTest.getDescription(), atomicTest);
        return atomicTest;
    }

    static AtomicTest getAtomicTestOf(Object testKey) {
        return RUNNER_TO_ATOMICTEST.get(testKey);
    }

    private static AtomicTest setTestFailure(Failure failure) {
        AtomicTest atomicTest = RunAnnouncer.getAtomicTestOf(Run.getThreadRunner());
        atomicTest.setThrowable(failure.getException());
        return atomicTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends JUnitWatcher> Optional<T> getAttachedWatcher(Class<T> watcherType) {
        if (RunWatcher.class.isAssignableFrom(watcherType)) {
            ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
            synchronized (serviceLoader) {
                for (RunWatcher watcher : runWatcherLoader) {
                    if (watcher.getClass() != watcherType) continue;
                    return Optional.of(watcher);
                }
            }
        }
        return Optional.empty();
    }

    static {
        RUNNER_TO_ATOMICTEST = new ConcurrentHashMap<Object, AtomicTest>();
        runWatcherLoader = ServiceLoader.load(RunWatcher.class);
    }
}

