/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.action;

import com.azure.core.util.FluxUtil;
import com.objective.threesixty.ObjectiveAction;
import com.objective.threesixty.ObjectiveActionType;
import com.objective.threesixty.remoteagent.sdk.BinaryDetails;
import com.objective.threesixty.remoteagent.sdk.action.Action;
import com.objective.threesixty.remoteagent.sdk.agent.Reader;
import com.objective.threesixty.remoteagent.sdk.config.RemoteAgentProperties;
import com.objective.threesixty.remoteagent.sdk.dto.CancelFileUploadRequest;
import com.objective.threesixty.remoteagent.sdk.dto.ChunkedFileUploadRequest;
import com.objective.threesixty.remoteagent.sdk.dto.CompleteFileUploadRequest;
import com.objective.threesixty.remoteagent.sdk.utils.CommunicationsManager;
import com.objective.threesixty.remoteagent.sdk.utils.CustomParameters;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

@Component
public final class BinariesAction
implements Action {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BinariesAction.class);
    private static final int MAX_CHUNK_SIZE_MB = 100;
    private static final int MAX_CHUNK_SIZE_BYTES = 0x6400000;
    private final CommunicationsManager commsManager;
    private final RemoteAgentProperties agentProperties;

    @Override
    public void execute(Reader reader, ObjectiveAction action) {
        BinaryDetails bd;
        CustomParameters parameters = new CustomParameters(action.getValueByIdMap());
        String docId = parameters.getDocId();
        try {
            bd = reader.getDocumentBinary(docId, parameters);
            if (bd == null) {
                bd = new BinaryDetails(docId, InputStream.nullInputStream(), "", false, "Null BinaryData returned from getDocumentBinary");
            } else {
                bd.setSuccess(true);
            }
        }
        catch (Exception e) {
            bd = new BinaryDetails(docId, InputStream.nullInputStream(), "", false, e.getMessage());
        }
        this.uploadFileInChunks(bd, parameters, action.getRequestId());
    }

    private void uploadFileInChunks(BinaryDetails bd, CustomParameters parameters, String requestId) {
        AtomicInteger chunksRead = new AtomicInteger();
        boolean includeHash = parameters.getIncludeHash();
        if (log.isTraceEnabled()) {
            log.trace("Beginning chunked binaries upload. {}", (Object)this.formattedLoggingIds(requestId, bd.getDocumentId()));
        }
        try (InputStream is = bd.getInputStream();){
            MessageDigest md = MessageDigest.getInstance("MD5");
            FluxUtil.toFluxByteBuffer((InputStream)(includeHash ? new DigestInputStream(is, md) : is), (int)0x6400000).concatMap(byteBuffer -> {
                byte[] byteArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byteArray);
                return Mono.fromCallable(() -> new AbstractMap.SimpleEntry<Integer, byte[]>(chunksRead.incrementAndGet(), byteArray));
            }).flatMap(entry -> this.uploadChunk(requestId, bd.getDocumentId(), (AbstractMap.SimpleEntry<Integer, byte[]>)entry)).then(Mono.defer(() -> {
                byte[] bytesToHash = includeHash ? md.digest() : null;
                return this.completeUpload(requestId, chunksRead.get(), bd, bytesToHash);
            })).publishOn(Schedulers.boundedElastic()).doOnError(throwable -> this.cancelUpload(requestId, bd.getDocumentId(), (Throwable)throwable).block()).doFinally(signalType -> {
                try {
                    bd.getInputStream().close();
                }
                catch (IOException e) {
                    log.error("Error closing input stream for {}", (Object)this.formattedLoggingIds(requestId, bd.getDocumentId()), (Object)e);
                }
            }).onErrorComplete().block();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public ObjectiveActionType getActionType() {
        return ObjectiveActionType.OBJECTIVE_ACTION_BINARIES;
    }

    private Mono<ResponseEntity<String>> uploadChunk(String requestId, String documentId, AbstractMap.SimpleEntry<Integer, byte[]> chunkEntry) {
        int chunkId = chunkEntry.getKey();
        if (log.isTraceEnabled()) {
            double sizeInMB = (double)chunkEntry.getValue().length / 1048576.0;
            log.trace("Uploading {} Chunk#{}: {}MB", new Object[]{this.formattedLoggingIds(requestId, documentId), chunkEntry.getKey(), sizeInMB});
        }
        String encodedChunk = Base64.getEncoder().encodeToString(chunkEntry.getValue());
        ChunkedFileUploadRequest requestBody = new ChunkedFileUploadRequest(requestId, documentId, this.agentProperties.getToken(), this.agentProperties.getAgentName(), chunkId, encodedChunk);
        return this.postRequest(this.commsManager.getChunkedUploadEndpoint(), requestBody);
    }

    private Mono<ResponseEntity<String>> completeUpload(String requestId, int chunksRead, BinaryDetails bd, byte[] bytesToHash) {
        CompleteFileUploadRequest requestBody = new CompleteFileUploadRequest(requestId, this.agentProperties.getToken(), this.agentProperties.getAgentName(), chunksRead, bd, null != bytesToHash ? DigestUtils.md5Hex((byte[])bytesToHash) : "");
        if (log.isTraceEnabled()) {
            log.trace("Completing binary upload for {}", (Object)this.formattedLoggingIds(requestId, requestBody.getDocumentId()));
        }
        return this.postRequest(this.commsManager.getCompleteFileUploadEndpoint(), requestBody);
    }

    private Mono<ResponseEntity<String>> cancelUpload(String requestId, String documentId, Throwable throwable) {
        CancelFileUploadRequest requestBody = new CancelFileUploadRequest(requestId, documentId, this.agentProperties.getToken(), this.agentProperties.getAgentName(), throwable.getMessage());
        log.error("Cancelling binary upload for {}:\n{}", new Object[]{this.formattedLoggingIds(requestId, documentId), throwable.getMessage(), throwable});
        return this.postRequest(this.commsManager.getCancelFileUploadEndpoint(), requestBody);
    }

    private Mono<ResponseEntity<String>> postRequest(String endpoint, Object requestBody) {
        return ((WebClient.RequestBodySpec)this.commsManager.getWebClient().post().uri(endpoint, new Object[0])).bodyValue(requestBody).retrieve().onStatus(status -> !status.is2xxSuccessful(), ClientResponse::createError).toEntity(String.class).retryWhen((Retry)this.retryBackoffSpec()).doOnSuccess(response -> log.debug((String)response.getBody())).onErrorStop();
    }

    private RetryBackoffSpec retryBackoffSpec() {
        return Retry.backoff((long)3L, (Duration)Duration.ofSeconds(2L)).filter(this::isTooManyRequestsException).doBeforeRetry(retrySignal -> log.error("Retry attempt #{}:\n{}", (Object)retrySignal.totalRetriesInARow(), (Object)retrySignal.failure().getMessage())).onRetryExhaustedThrow((retryBackoffSpec, retrySignal) -> retrySignal.failure());
    }

    private boolean isTooManyRequestsException(Throwable throwable) {
        return throwable instanceof WebClientResponseException.TooManyRequests;
    }

    private String formattedLoggingIds(String requestId, String documentId) {
        return "[Request ID: " + requestId + ", DocumentId: " + documentId + "]";
    }

    @Generated
    public BinariesAction(CommunicationsManager commsManager, RemoteAgentProperties agentProperties) {
        this.commsManager = commsManager;
        this.agentProperties = agentProperties;
    }
}

