/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.action;

import com.objective.threesixty.ActionStatusResponse;
import com.objective.threesixty.Document;
import com.objective.threesixty.JobRunGrpc;
import com.objective.threesixty.ObjectiveAction;
import com.objective.threesixty.ObjectiveActionType;
import com.objective.threesixty.remoteagent.sdk.action.Action;
import com.objective.threesixty.remoteagent.sdk.agent.Reader;
import com.objective.threesixty.remoteagent.sdk.config.RemoteAgentProperties;
import com.objective.threesixty.remoteagent.sdk.utils.CommunicationsManager;
import com.objective.threesixty.remoteagent.sdk.utils.CustomParameters;
import com.objective.threesixty.remoteagent.sdk.utils.StatusUtils;
import io.grpc.Channel;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class DeleteAction
implements Action {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeleteAction.class);
    private final CommunicationsManager commsManager;
    private final RemoteAgentProperties agentProperties;

    @Override
    public void execute(Reader reader, ObjectiveAction action) {
        JobRunGrpc.JobRunBlockingStub documentBlockingStub = JobRunGrpc.newBlockingStub((Channel)this.commsManager.getChannel());
        CustomParameters parameters = new CustomParameters(action.getValueByIdMap());
        Document document = Document.newBuilder().setId(parameters.getDocId()).setRequestId(action.getRequestId()).build();
        try {
            reader.deleteDocument(parameters.getDocId(), parameters);
        }
        catch (Exception e) {
            log.error("Error deleting document with Remote Agent. request id: {} doc ID: {}", (Object)action.getRequestId(), (Object)parameters.getDocId());
            document = Document.newBuilder((Document)document).setStatus(StatusUtils.failure(e.getMessage())).build();
            ((JobRunGrpc.JobRunBlockingStub)documentBlockingStub.withDeadlineAfter(this.agentProperties.getGrpcServer().getTimeouts().getSendDeletionResponseRpc(), TimeUnit.SECONDS)).sendDeletionResponse(document);
            return;
        }
        document = Document.newBuilder((Document)document).setStatus(StatusUtils.success("success")).build();
        ActionStatusResponse actionStatusResponse = ((JobRunGrpc.JobRunBlockingStub)documentBlockingStub.withDeadlineAfter(this.agentProperties.getGrpcServer().getTimeouts().getSendDeletionResponseRpc(), TimeUnit.SECONDS)).sendDeletionResponse(document);
        log.debug("Document Deleted. request id: {} doc id: {} status: {} ", new Object[]{action.getRequestId(), parameters.getDocId(), actionStatusResponse.getStatus()});
    }

    @Override
    public ObjectiveActionType getActionType() {
        return ObjectiveActionType.OBJECTIVE_ACTION_DELETE;
    }

    @Generated
    public DeleteAction(CommunicationsManager commsManager, RemoteAgentProperties agentProperties) {
        this.commsManager = commsManager;
        this.agentProperties = agentProperties;
    }
}

