/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.action;

import com.objective.threesixty.DocumentMetadata;
import com.objective.threesixty.MetadataType;
import com.objective.threesixty.ObjectiveAction;
import com.objective.threesixty.ObjectiveActionType;
import com.objective.threesixty.remoteagent.sdk.action.Action;
import com.objective.threesixty.remoteagent.sdk.agent.Reader;
import com.objective.threesixty.remoteagent.sdk.config.RemoteAgentProperties;
import com.objective.threesixty.remoteagent.sdk.utils.CommunicationsManager;
import com.objective.threesixty.remoteagent.sdk.utils.CustomParameters;
import com.objective.threesixty.remoteagent.sdk.utils.StatusUtils;
import com.objective.threesixty.remoteagent.sdk.utils.StreamObserverFactory;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class MetadataAction
implements Action {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataAction.class);
    private final CommunicationsManager commsManager;
    private final RemoteAgentProperties agentProperties;

    @Override
    public void execute(Reader reader, ObjectiveAction action) {
        CustomParameters parameters = new CustomParameters(action.getValueByIdMap());
        String docId = parameters.getDocId();
        StreamObserver<DocumentMetadata> requestObserver = StreamObserverFactory.createDocumentMetadataObserver(this.commsManager.getChannel(), this.agentProperties.getGrpcServer().getTimeouts().getShareDocumentMetadataRpc(), action.getRequestId());
        DocumentMetadata.Builder builder = DocumentMetadata.newBuilder().setRequestId(action.getRequestId()).setDocId(docId).setRequestId(action.getRequestId());
        try {
            Map<String, MetadataType> metadata = reader.getDocumentMetadata(docId, parameters);
            builder.putAllDocMetadata(metadata).setStatus(StatusUtils.success("Success"));
        }
        catch (Exception e) {
            HashMap metadataTypeMap = new HashMap();
            builder.putAllDocMetadata(metadataTypeMap).setStatus(StatusUtils.failure(e.getMessage()));
        }
        DocumentMetadata request = builder.build();
        requestObserver.onNext((Object)request);
        requestObserver.onCompleted();
    }

    @Override
    public ObjectiveActionType getActionType() {
        return ObjectiveActionType.OBJECTIVE_ACTION_METADATA;
    }

    @Generated
    public MetadataAction(CommunicationsManager commsManager, RemoteAgentProperties agentProperties) {
        this.commsManager = commsManager;
        this.agentProperties = agentProperties;
    }
}

