/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.dto;

import com.google.common.base.Strings;
import com.objective.threesixty.remoteagent.sdk.BinaryDetails;
import java.util.Objects;
import lombok.Generated;

public final class CompleteFileUploadRequest {
    private String requestId;
    private String documentId;
    private String token;
    private String agentName;
    private boolean success;
    private String message;
    private int totalChunks;
    private String mimeType;
    private String md5Checksum;

    public CompleteFileUploadRequest(String requestId, String token, String agentName, int totalChunks, BinaryDetails bd, String md5Checksum) {
        this.requestId = requestId;
        this.token = token;
        this.agentName = agentName;
        this.documentId = bd.getDocumentId();
        this.mimeType = Objects.requireNonNullElse(bd.getMimeType(), "application/octet-stream");
        this.success = bd.isSuccess();
        this.message = Strings.nullToEmpty((String)bd.getMessage());
        this.totalChunks = totalChunks;
        this.md5Checksum = md5Checksum;
    }

    @Generated
    public String getRequestId() {
        return this.requestId;
    }

    @Generated
    public String getDocumentId() {
        return this.documentId;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public String getAgentName() {
        return this.agentName;
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public int getTotalChunks() {
        return this.totalChunks;
    }

    @Generated
    public String getMimeType() {
        return this.mimeType;
    }

    @Generated
    public String getMd5Checksum() {
        return this.md5Checksum;
    }

    @Generated
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @Generated
    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    @Generated
    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setTotalChunks(int totalChunks) {
        this.totalChunks = totalChunks;
    }

    @Generated
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Generated
    public void setMd5Checksum(String md5Checksum) {
        this.md5Checksum = md5Checksum;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompleteFileUploadRequest)) {
            return false;
        }
        CompleteFileUploadRequest other = (CompleteFileUploadRequest)o;
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (this.getTotalChunks() != other.getTotalChunks()) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$documentId = this.getDocumentId();
        String other$documentId = other.getDocumentId();
        if (this$documentId == null ? other$documentId != null : !this$documentId.equals(other$documentId)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$agentName = this.getAgentName();
        String other$agentName = other.getAgentName();
        if (this$agentName == null ? other$agentName != null : !this$agentName.equals(other$agentName)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$mimeType = this.getMimeType();
        String other$mimeType = other.getMimeType();
        if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
            return false;
        }
        String this$md5Checksum = this.getMd5Checksum();
        String other$md5Checksum = other.getMd5Checksum();
        return !(this$md5Checksum == null ? other$md5Checksum != null : !this$md5Checksum.equals(other$md5Checksum));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        result = result * 59 + this.getTotalChunks();
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $documentId = this.getDocumentId();
        result = result * 59 + ($documentId == null ? 43 : $documentId.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $agentName = this.getAgentName();
        result = result * 59 + ($agentName == null ? 43 : $agentName.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $mimeType = this.getMimeType();
        result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
        String $md5Checksum = this.getMd5Checksum();
        result = result * 59 + ($md5Checksum == null ? 43 : $md5Checksum.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CompleteFileUploadRequest(requestId=" + this.getRequestId() + ", documentId=" + this.getDocumentId() + ", token=" + this.getToken() + ", agentName=" + this.getAgentName() + ", success=" + this.isSuccess() + ", message=" + this.getMessage() + ", totalChunks=" + this.getTotalChunks() + ", mimeType=" + this.getMimeType() + ", md5Checksum=" + this.getMd5Checksum() + ")";
    }
}

