/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.utils;

import com.objective.threesixty.Value;
import com.objective.threesixty.remoteagent.sdk.utils.ReservedIdentifier;
import com.objective.threesixty.remoteagent.sdk.utils.ValueUtils;
import java.util.Map;
import lombok.Generated;

public class CustomParameters {
    private final Map<String, Value> params;

    public boolean containsKey(String key) {
        return this.params.containsKey(key);
    }

    public Value get(String key) {
        return this.params.get(key);
    }

    public void put(String key, Value value) {
        this.params.put(key, value);
    }

    public Value getOrDefault(String key, Value defaultValue) {
        return this.params.getOrDefault(key, defaultValue);
    }

    public long getStartTimeOfDateFilter() {
        return this.params.getOrDefault(ReservedIdentifier.START_TIME.getName(), ValueUtils.longValue(Long.MIN_VALUE)).getLong();
    }

    public long getEndTimeOfDateFilter() {
        return this.params.getOrDefault(ReservedIdentifier.END_TIME.getName(), ValueUtils.longValue(Long.MAX_VALUE)).getLong();
    }

    public boolean getIncludeBinaries() {
        return this.params.getOrDefault(ReservedIdentifier.INCLUDE_BINARIES_PARAM.getName(), ValueUtils.booleanValue(false)).getBoolean();
    }

    public String getDocId() {
        return this.params.get(ReservedIdentifier.DOC_ID_PARAM.getName()).getString();
    }

    public boolean getIncludeHash() {
        return this.params.getOrDefault(ReservedIdentifier.INCLUDE_HASH_PARAM.getName(), ValueUtils.booleanValue(false)).getBoolean();
    }

    public long getMaxFileSizeHash() {
        long maxNtfsSizeMb = 0x10000000L;
        return this.getIncludeHash() ? this.params.getOrDefault(ReservedIdentifier.MAX_FILE_SIZE_HASH.getName(), ValueUtils.longValue(maxNtfsSizeMb)).getLong() : 0L;
    }

    public boolean deleteAllVersions() {
        return this.params.getOrDefault(ReservedIdentifier.ALL_VERSIONS_PARAM.getName(), ValueUtils.booleanValue(false)).getBoolean();
    }

    @Generated
    public CustomParameters(Map<String, Value> params) {
        this.params = params;
    }
}

