/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.utils;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class HeaderClientInterceptor
implements ClientInterceptor {
    private static final Log log = LogFactory.getLog(HeaderClientInterceptor.class);
    private static final Metadata.Key<String> TOKEN_HEADER_KEY = Metadata.Key.of((String)"remote_agent_header_key", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final String requestValue;

    HeaderClientInterceptor(String requestValue) {
        this.requestValue = requestValue;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.put(TOKEN_HEADER_KEY, (Object)HeaderClientInterceptor.this.requestValue);
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onHeaders(Metadata headers) {
                        log.debug((Object)("Header received from server: " + headers));
                        super.onHeaders(headers);
                    }
                }, headers);
            }
        };
    }
}

