/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.action;

import com.objective.threesixty.ActionStatusResponse;
import com.objective.threesixty.Document;
import com.objective.threesixty.JobRunGrpc;
import com.objective.threesixty.ObjectiveAction;
import com.objective.threesixty.ObjectiveActionType;
import com.objective.threesixty.remoteagent.sdk.action.Action;
import com.objective.threesixty.remoteagent.sdk.agent.RepositoryReader;
import com.objective.threesixty.remoteagent.sdk.config.RemoteAgentProperties;
import com.objective.threesixty.remoteagent.sdk.utils.CommunicationsManager;
import com.objective.threesixty.remoteagent.sdk.utils.CustomParameters;
import com.objective.threesixty.remoteagent.sdk.utils.StatusUtils;
import io.grpc.Channel;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public final class DeleteAction
implements Action {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final CommunicationsManager commsManager;
    private final RemoteAgentProperties agentProperties;
    private final RepositoryReader reader;

    @Override
    public void execute(ObjectiveAction action) {
        JobRunGrpc.JobRunBlockingStub documentBlockingStub = JobRunGrpc.newBlockingStub((Channel)this.commsManager.getChannel());
        CustomParameters parameters = new CustomParameters(action.getValueByIdMap());
        Document document = Document.newBuilder().setId(parameters.getDocId()).setRequestId(action.getRequestId()).build();
        try {
            this.reader.deleteDocument(parameters.getDocId(), parameters);
        }
        catch (Exception e) {
            this.log.error("Error deleting document with Remote Agent. request id: {} doc ID: {}", (Object)action.getRequestId(), (Object)parameters.getDocId());
            document = Document.newBuilder((Document)document).setStatus(StatusUtils.failure(e.getMessage())).build();
            ((JobRunGrpc.JobRunBlockingStub)documentBlockingStub.withDeadlineAfter(this.agentProperties.getGrpcServer().getTimeouts().getSendDeletionResponseRpc(), TimeUnit.SECONDS)).sendDeletionResponse(document);
            return;
        }
        document = Document.newBuilder((Document)document).setStatus(StatusUtils.success("success")).build();
        ActionStatusResponse actionStatusResponse = ((JobRunGrpc.JobRunBlockingStub)documentBlockingStub.withDeadlineAfter(this.agentProperties.getGrpcServer().getTimeouts().getSendDeletionResponseRpc(), TimeUnit.SECONDS)).sendDeletionResponse(document);
        this.log.debug("Document Deleted. request id: {} doc id: {} status: {}", (Object)action.getRequestId(), (Object)parameters.getDocId(), (Object)actionStatusResponse.getStatus());
    }

    @Override
    public ObjectiveActionType getActionType() {
        return ObjectiveActionType.OBJECTIVE_ACTION_DELETE;
    }

    @Generated
    public DeleteAction(CommunicationsManager commsManager, RemoteAgentProperties agentProperties, RepositoryReader reader) {
        this.commsManager = commsManager;
        this.agentProperties = agentProperties;
        this.reader = reader;
    }
}

