/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.action;

import com.objective.threesixty.ActionStatusResponse;
import com.objective.threesixty.Document;
import com.objective.threesixty.JobRunGrpc;
import com.objective.threesixty.ObjectiveAction;
import com.objective.threesixty.ObjectiveActionType;
import com.objective.threesixty.remoteagent.sdk.action.Action;
import com.objective.threesixty.remoteagent.sdk.agent.RepositoryReader;
import com.objective.threesixty.remoteagent.sdk.config.RemoteAgentProperties;
import com.objective.threesixty.remoteagent.sdk.utils.CommunicationsManager;
import com.objective.threesixty.remoteagent.sdk.utils.CustomParameters;
import com.objective.threesixty.remoteagent.sdk.utils.StatusUtils;
import io.grpc.Channel;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public final class DocumentAction
implements Action {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final CommunicationsManager commsManager;
    private final RemoteAgentProperties agentProperties;
    private final RepositoryReader reader;

    @Override
    public void execute(ObjectiveAction action) {
        Document document;
        JobRunGrpc.JobRunBlockingStub documentBlockingStub = JobRunGrpc.newBlockingStub((Channel)this.commsManager.getChannel());
        CustomParameters parameters = new CustomParameters(action.getValueByIdMap());
        try {
            document = this.reader.getDocument(parameters.getDocId(), parameters);
        }
        catch (Exception e) {
            this.log.error("Error Reading document from Remote Agent. request id: {} doc ID: {}", (Object)action.getRequestId(), (Object)parameters.getDocId());
            Document document2 = Document.newBuilder().setId(parameters.getDocId()).setStatus(StatusUtils.failure(e.getMessage())).setRequestId(action.getRequestId()).build();
            ((JobRunGrpc.JobRunBlockingStub)documentBlockingStub.withDeadlineAfter(this.agentProperties.getGrpcServer().getTimeouts().getShareDocumentRpc(), TimeUnit.SECONDS)).shareDocument(document2);
            return;
        }
        document = Document.newBuilder((Document)document).setStatus(StatusUtils.success("success")).setRequestId(action.getRequestId()).build();
        ActionStatusResponse actionStatusResponse = ((JobRunGrpc.JobRunBlockingStub)documentBlockingStub.withDeadlineAfter(this.agentProperties.getGrpcServer().getTimeouts().getShareDocumentRpc(), TimeUnit.SECONDS)).shareDocument(document);
        this.log.debug("Document sent. request id: {} doc id: {} status: {} ", (Object)action.getRequestId(), (Object)parameters.getDocId(), (Object)actionStatusResponse.getStatus());
    }

    @Override
    public ObjectiveActionType getActionType() {
        return ObjectiveActionType.OBJECTIVE_ACTION_DOCUMENT;
    }

    @Generated
    public DocumentAction(CommunicationsManager commsManager, RemoteAgentProperties agentProperties, RepositoryReader reader) {
        this.commsManager = commsManager;
        this.agentProperties = agentProperties;
        this.reader = reader;
    }
}

