/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.config;

import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="remote-agent")
public final class RemoteAgentProperties {
    @NotBlank
    private String token;
    @NotBlank
    private String agentName;
    @NotBlank
    private String serverUrl;
    private SslConfig sslConfig = new SslConfig();
    private GrpcServer grpcServer = new GrpcServer();

    public String getSanitizedServerUrl() {
        return this.serverUrl.replaceAll("/+$", "");
    }

    @Generated
    public RemoteAgentProperties() {
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public String getAgentName() {
        return this.agentName;
    }

    @Generated
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Generated
    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    @Generated
    public GrpcServer getGrpcServer() {
        return this.grpcServer;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    @Generated
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @Generated
    public void setSslConfig(SslConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    @Generated
    public void setGrpcServer(GrpcServer grpcServer) {
        this.grpcServer = grpcServer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteAgentProperties)) {
            return false;
        }
        RemoteAgentProperties other = (RemoteAgentProperties)o;
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$agentName = this.getAgentName();
        String other$agentName = other.getAgentName();
        if (this$agentName == null ? other$agentName != null : !this$agentName.equals(other$agentName)) {
            return false;
        }
        String this$serverUrl = this.getServerUrl();
        String other$serverUrl = other.getServerUrl();
        if (this$serverUrl == null ? other$serverUrl != null : !this$serverUrl.equals(other$serverUrl)) {
            return false;
        }
        SslConfig this$sslConfig = this.getSslConfig();
        SslConfig other$sslConfig = other.getSslConfig();
        if (this$sslConfig == null ? other$sslConfig != null : !((Object)this$sslConfig).equals(other$sslConfig)) {
            return false;
        }
        GrpcServer this$grpcServer = this.getGrpcServer();
        GrpcServer other$grpcServer = other.getGrpcServer();
        return !(this$grpcServer == null ? other$grpcServer != null : !((Object)this$grpcServer).equals(other$grpcServer));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $agentName = this.getAgentName();
        result = result * 59 + ($agentName == null ? 43 : $agentName.hashCode());
        String $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : $serverUrl.hashCode());
        SslConfig $sslConfig = this.getSslConfig();
        result = result * 59 + ($sslConfig == null ? 43 : ((Object)$sslConfig).hashCode());
        GrpcServer $grpcServer = this.getGrpcServer();
        result = result * 59 + ($grpcServer == null ? 43 : ((Object)$grpcServer).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RemoteAgentProperties(token=" + this.getToken() + ", agentName=" + this.getAgentName() + ", serverUrl=" + this.getServerUrl() + ", sslConfig=" + this.getSslConfig() + ", grpcServer=" + this.getGrpcServer() + ")";
    }

    @Validated
    public static class SslConfig {
        private boolean enabled;
        private CaCerts caCerts = new CaCerts();

        @Generated
        public SslConfig() {
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public CaCerts getCaCerts() {
            return this.caCerts;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setCaCerts(CaCerts caCerts) {
            this.caCerts = caCerts;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SslConfig)) {
                return false;
            }
            SslConfig other = (SslConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            CaCerts this$caCerts = this.getCaCerts();
            CaCerts other$caCerts = other.getCaCerts();
            return !(this$caCerts == null ? other$caCerts != null : !((Object)this$caCerts).equals(other$caCerts));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SslConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            CaCerts $caCerts = this.getCaCerts();
            result = result * 59 + ($caCerts == null ? 43 : ((Object)$caCerts).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RemoteAgentProperties.SslConfig(enabled=" + this.isEnabled() + ", caCerts=" + this.getCaCerts() + ")";
        }
    }

    @Validated
    public static class GrpcServer {
        @NotBlank
        private String host;
        @Min(value=1025L)
        @Max(value=65536L)
        private @Min(value=1025L) @Max(value=65536L) int port;
        private Timeout timeouts = new Timeout();

        @Generated
        public GrpcServer() {
        }

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public Timeout getTimeouts() {
            return this.timeouts;
        }

        @Generated
        public void setHost(String host) {
            this.host = host;
        }

        @Generated
        public void setPort(int port) {
            this.port = port;
        }

        @Generated
        public void setTimeouts(Timeout timeouts) {
            this.timeouts = timeouts;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GrpcServer)) {
                return false;
            }
            GrpcServer other = (GrpcServer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            Timeout this$timeouts = this.getTimeouts();
            Timeout other$timeouts = other.getTimeouts();
            return !(this$timeouts == null ? other$timeouts != null : !((Object)this$timeouts).equals(other$timeouts));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GrpcServer;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            Timeout $timeouts = this.getTimeouts();
            result = result * 59 + ($timeouts == null ? 43 : ((Object)$timeouts).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RemoteAgentProperties.GrpcServer(host=" + this.getHost() + ", port=" + this.getPort() + ", timeouts=" + this.getTimeouts() + ")";
        }

        public static class Timeout {
            @Min(value=1L)
            @Max(value=0x7FFFFFFFFFFFFFFFL)
            private @Min(value=1L) @Max(value=0x7FFFFFFFFFFFFFFFL) long configureConnectorFormRpc = 120L;
            @Min(value=1L)
            @Max(value=0x7FFFFFFFFFFFFFFFL)
            private @Min(value=1L) @Max(value=0x7FFFFFFFFFFFFFFFL) long shareDocumentMetadataRpc = 60L;
            @Min(value=1L)
            @Max(value=0x7FFFFFFFFFFFFFFFL)
            private @Min(value=1L) @Max(value=0x7FFFFFFFFFFFFFFFL) long shareDocumentsRpc = 300L;
            @Min(value=1L)
            @Max(value=0x7FFFFFFFFFFFFFFFL)
            private @Min(value=1L) @Max(value=0x7FFFFFFFFFFFFFFFL) long shareDocumentRpc = 60L;
            @Min(value=1L)
            @Max(value=0x7FFFFFFFFFFFFFFFL)
            private @Min(value=1L) @Max(value=0x7FFFFFFFFFFFFFFFL) long sendDeletionResponseRpc = 60L;
            @Min(value=1L)
            @Max(value=0x7FFFFFFFFFFFFFFFL)
            private @Min(value=1L) @Max(value=0x7FFFFFFFFFFFFFFFL) long writeDocumentRequestRpc = 300L;
            @Min(value=1L)
            @Max(value=0x7FFFFFFFFFFFFFFFL)
            private @Min(value=1L) @Max(value=0x7FFFFFFFFFFFFFFFL) long getExtendedDocumentRpc = 300L;
            @Min(value=1L)
            @Max(value=0x7FFFFFFFFFFFFFFFL)
            private @Min(value=1L) @Max(value=0x7FFFFFFFFFFFFFFFL) long validateAgentTokenRpc = 60L;

            @Generated
            public Timeout() {
            }

            @Generated
            public long getConfigureConnectorFormRpc() {
                return this.configureConnectorFormRpc;
            }

            @Generated
            public long getShareDocumentMetadataRpc() {
                return this.shareDocumentMetadataRpc;
            }

            @Generated
            public long getShareDocumentsRpc() {
                return this.shareDocumentsRpc;
            }

            @Generated
            public long getShareDocumentRpc() {
                return this.shareDocumentRpc;
            }

            @Generated
            public long getSendDeletionResponseRpc() {
                return this.sendDeletionResponseRpc;
            }

            @Generated
            public long getWriteDocumentRequestRpc() {
                return this.writeDocumentRequestRpc;
            }

            @Generated
            public long getGetExtendedDocumentRpc() {
                return this.getExtendedDocumentRpc;
            }

            @Generated
            public long getValidateAgentTokenRpc() {
                return this.validateAgentTokenRpc;
            }

            @Generated
            public void setConfigureConnectorFormRpc(long configureConnectorFormRpc) {
                this.configureConnectorFormRpc = configureConnectorFormRpc;
            }

            @Generated
            public void setShareDocumentMetadataRpc(long shareDocumentMetadataRpc) {
                this.shareDocumentMetadataRpc = shareDocumentMetadataRpc;
            }

            @Generated
            public void setShareDocumentsRpc(long shareDocumentsRpc) {
                this.shareDocumentsRpc = shareDocumentsRpc;
            }

            @Generated
            public void setShareDocumentRpc(long shareDocumentRpc) {
                this.shareDocumentRpc = shareDocumentRpc;
            }

            @Generated
            public void setSendDeletionResponseRpc(long sendDeletionResponseRpc) {
                this.sendDeletionResponseRpc = sendDeletionResponseRpc;
            }

            @Generated
            public void setWriteDocumentRequestRpc(long writeDocumentRequestRpc) {
                this.writeDocumentRequestRpc = writeDocumentRequestRpc;
            }

            @Generated
            public void setGetExtendedDocumentRpc(long getExtendedDocumentRpc) {
                this.getExtendedDocumentRpc = getExtendedDocumentRpc;
            }

            @Generated
            public void setValidateAgentTokenRpc(long validateAgentTokenRpc) {
                this.validateAgentTokenRpc = validateAgentTokenRpc;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Timeout)) {
                    return false;
                }
                Timeout other = (Timeout)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getConfigureConnectorFormRpc() != other.getConfigureConnectorFormRpc()) {
                    return false;
                }
                if (this.getShareDocumentMetadataRpc() != other.getShareDocumentMetadataRpc()) {
                    return false;
                }
                if (this.getShareDocumentsRpc() != other.getShareDocumentsRpc()) {
                    return false;
                }
                if (this.getShareDocumentRpc() != other.getShareDocumentRpc()) {
                    return false;
                }
                if (this.getSendDeletionResponseRpc() != other.getSendDeletionResponseRpc()) {
                    return false;
                }
                if (this.getWriteDocumentRequestRpc() != other.getWriteDocumentRequestRpc()) {
                    return false;
                }
                if (this.getGetExtendedDocumentRpc() != other.getGetExtendedDocumentRpc()) {
                    return false;
                }
                return this.getValidateAgentTokenRpc() == other.getValidateAgentTokenRpc();
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Timeout;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $configureConnectorFormRpc = this.getConfigureConnectorFormRpc();
                result = result * 59 + (int)($configureConnectorFormRpc >>> 32 ^ $configureConnectorFormRpc);
                long $shareDocumentMetadataRpc = this.getShareDocumentMetadataRpc();
                result = result * 59 + (int)($shareDocumentMetadataRpc >>> 32 ^ $shareDocumentMetadataRpc);
                long $shareDocumentsRpc = this.getShareDocumentsRpc();
                result = result * 59 + (int)($shareDocumentsRpc >>> 32 ^ $shareDocumentsRpc);
                long $shareDocumentRpc = this.getShareDocumentRpc();
                result = result * 59 + (int)($shareDocumentRpc >>> 32 ^ $shareDocumentRpc);
                long $sendDeletionResponseRpc = this.getSendDeletionResponseRpc();
                result = result * 59 + (int)($sendDeletionResponseRpc >>> 32 ^ $sendDeletionResponseRpc);
                long $writeDocumentRequestRpc = this.getWriteDocumentRequestRpc();
                result = result * 59 + (int)($writeDocumentRequestRpc >>> 32 ^ $writeDocumentRequestRpc);
                long $getExtendedDocumentRpc = this.getGetExtendedDocumentRpc();
                result = result * 59 + (int)($getExtendedDocumentRpc >>> 32 ^ $getExtendedDocumentRpc);
                long $validateAgentTokenRpc = this.getValidateAgentTokenRpc();
                result = result * 59 + (int)($validateAgentTokenRpc >>> 32 ^ $validateAgentTokenRpc);
                return result;
            }

            @Generated
            public String toString() {
                return "RemoteAgentProperties.GrpcServer.Timeout(configureConnectorFormRpc=" + this.getConfigureConnectorFormRpc() + ", shareDocumentMetadataRpc=" + this.getShareDocumentMetadataRpc() + ", shareDocumentsRpc=" + this.getShareDocumentsRpc() + ", shareDocumentRpc=" + this.getShareDocumentRpc() + ", sendDeletionResponseRpc=" + this.getSendDeletionResponseRpc() + ", writeDocumentRequestRpc=" + this.getWriteDocumentRequestRpc() + ", getExtendedDocumentRpc=" + this.getGetExtendedDocumentRpc() + ", validateAgentTokenRpc=" + this.getValidateAgentTokenRpc() + ")";
            }
        }
    }

    public static class CaCerts {
        private String password;

        @Generated
        public CaCerts() {
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CaCerts)) {
                return false;
            }
            CaCerts other = (CaCerts)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CaCerts;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RemoteAgentProperties.CaCerts(password=" + this.getPassword() + ")";
        }
    }
}

