/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.action;

import com.objective.threesixty.Document;
import com.objective.threesixty.ObjectiveAction;
import com.objective.threesixty.ObjectiveActionType;
import com.objective.threesixty.remoteagent.sdk.action.Action;
import com.objective.threesixty.remoteagent.sdk.agent.AuthConnection;
import com.objective.threesixty.remoteagent.sdk.agent.RepositoryReader;
import com.objective.threesixty.remoteagent.sdk.config.RemoteAgentProperties;
import com.objective.threesixty.remoteagent.sdk.utils.CommunicationsManager;
import com.objective.threesixty.remoteagent.sdk.utils.CustomParameters;
import com.objective.threesixty.remoteagent.sdk.utils.ReservedIdentifier;
import com.objective.threesixty.remoteagent.sdk.utils.StatusUtils;
import com.objective.threesixty.remoteagent.sdk.utils.StreamObserverFactory;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public final class ListDocumentsAction
implements Action {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final CommunicationsManager commsManager;
    private final RemoteAgentProperties agentProperties;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final RepositoryReader reader;

    @Override
    public void execute(ObjectiveAction action) {
        CustomParameters parameters = new CustomParameters(action.getValueByIdMap());
        StreamObserver<Document> requestObserver = StreamObserverFactory.createDocumentListObserver(this.commsManager.getChannel(), this.agentProperties.getGrpcServer().getTimeouts().getShareDocumentsRpc(), action.getRequestId());
        this.executorService.submit(() -> {
            AtomicInteger counter = new AtomicInteger(0);
            try {
                try (Stream<Document> stream = this.reader.getDocuments(parameters, new AuthConnection(action.getAuthConn()));){
                    stream.filter(Objects::nonNull).map(doc -> Document.newBuilder((Document)doc).setRequestId(action.getRequestId()).setStatus(StatusUtils.success("Success")).build()).forEach(doc -> {
                        counter.incrementAndGet();
                        requestObserver.onNext(doc);
                    });
                }
                requestObserver.onNext((Object)Document.newBuilder().setId(ReservedIdentifier.POISON_DOCUMENT_ID.getName() + counter.get()).setStatus(StatusUtils.success("Success")).setRequestId(action.getRequestId()).build());
            }
            catch (Exception e) {
                this.log.error("Error getting list of source documents.", (Throwable)e);
                requestObserver.onNext((Object)Document.newBuilder().setId(ReservedIdentifier.POISON_DOCUMENT_ID.getName() + counter.get()).setStatus(StatusUtils.failure(e.getMessage())).setRequestId(action.getRequestId()).build());
            }
            requestObserver.onCompleted();
        });
    }

    @Override
    public ObjectiveActionType getActionType() {
        return ObjectiveActionType.OBJECTIVE_ACTION_LIST_DOCUMENTS;
    }

    @Generated
    public ListDocumentsAction(CommunicationsManager commsManager, RemoteAgentProperties agentProperties, RepositoryReader reader) {
        this.commsManager = commsManager;
        this.agentProperties = agentProperties;
        this.reader = reader;
    }
}

