/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.action;

import com.objective.threesixty.ContentSearchGrpc;
import com.objective.threesixty.ContentSearchResponse;
import com.objective.threesixty.ObjectiveAction;
import com.objective.threesixty.ObjectiveActionType;
import com.objective.threesixty.Status;
import com.objective.threesixty.StatusCode;
import com.objective.threesixty.Value;
import com.objective.threesixty.remoteagent.sdk.action.Action;
import com.objective.threesixty.remoteagent.sdk.agent.AuthConnection;
import com.objective.threesixty.remoteagent.sdk.agent.ContentSearchService;
import com.objective.threesixty.remoteagent.sdk.config.RemoteAgentProperties;
import com.objective.threesixty.remoteagent.sdk.utils.CommunicationsManager;
import com.objective.threesixty.remoteagent.sdk.utils.CustomParameters;
import com.objective.threesixty.remoteagent.sdk.utils.ReservedIdentifier;
import io.grpc.Channel;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class QueryAction
implements Action {
    private final ContentSearchService contentSearchService;
    private final CommunicationsManager commsManager;
    private final RemoteAgentProperties agentProperties;

    @Override
    public void execute(ObjectiveAction action) {
        HashMap<String, Value> valuesById = new HashMap<String, Value>(action.getValueByIdMap());
        CustomParameters params = new CustomParameters(valuesById);
        String collection = params.removeString(ReservedIdentifier.COLLECTION_PARAM.getName());
        String searchString = params.removeString(ReservedIdentifier.SEARCH_STRING_PARAM.getName());
        ContentSearchGrpc.ContentSearchBlockingStub stub = ContentSearchGrpc.newBlockingStub((Channel)this.commsManager.getChannel());
        stub.withDeadlineAfter(this.agentProperties.getGrpcServer().getTimeouts().getSendQueryResponseRpc(), TimeUnit.SECONDS);
        ContentSearchResponse.Builder csResponse = ContentSearchResponse.newBuilder().setRequestId(action.getRequestId());
        try {
            String response = this.contentSearchService.runQuery(new AuthConnection(action.getAuthConn()), collection, searchString, params);
            stub.sendQueryResponse(csResponse.setResult(response).setStatus(Status.newBuilder().setCode(StatusCode.STATUS_CODE_SUCCESS).build()).build());
        }
        catch (Exception e) {
            stub.sendQueryResponse(csResponse.setResult("").setStatus(Status.newBuilder().setCode(StatusCode.STATUS_CODE_FAILURE).setMessage(e.getMessage()).build()).build());
        }
    }

    @Override
    public ObjectiveActionType getActionType() {
        return ObjectiveActionType.OBJECTIVE_ACTION_RUN_QUERY;
    }

    @Generated
    public QueryAction(ContentSearchService contentSearchService, CommunicationsManager commsManager, RemoteAgentProperties agentProperties) {
        this.contentSearchService = contentSearchService;
        this.commsManager = commsManager;
        this.agentProperties = agentProperties;
    }
}

