/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.utils;

import com.objective.threesixty.Response;
import com.objective.threesixty.TokenValidationRequest;
import com.objective.threesixty.ValidatorGrpc;
import com.objective.threesixty.remoteagent.sdk.config.RemoteAgentProperties;
import com.objective.threesixty.remoteagent.sdk.utils.CertificateUtils;
import com.objective.threesixty.remoteagent.sdk.utils.HeaderClientInterceptor;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.netty.handler.ssl.SslContext;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.netty.http.client.HttpClient;

@Component
public final class CommunicationsManager {
    private final Logger log = LogManager.getLogger(this.getClass());
    private static final String BASE_UPLOAD_ENDPOINT = "/api/public/remoteagents/jobruns/documents/chunk/";
    private static final String CHUNKED_UPLOAD_ENDPOINT = "/api/public/remoteagents/jobruns/documents/chunk/upload";
    private static final String COMPLETE_FILE_UPLOAD_ENDPOINT = "/api/public/remoteagents/jobruns/documents/chunk/complete";
    private static final String CANCEL_FILE_UPLOAD_ENDPOINT = "/api/public/remoteagents/jobruns/documents/chunk/cancel";
    private static final String DOWNLOAD_FILE_BINARIES_ENDPOINT = "/api/public/remoteagents/jobruns/documents/binaries/{requestId}";
    private static final String GENERATE_DOWNLOAD_LINK_ENDPOINT = "/api/public/remoteagents/files/external/link";
    private static final String PUBLIC_DOWNLOAD_ENDPOINT = "/api/public/download?key={key}";
    private final RemoteAgentProperties agentProperties;
    private ManagedChannel channel;
    private WebClient webClient;

    public void initialize() throws GeneralSecurityException, IOException {
        TrustManagerFactory tmf = null;
        if (this.agentProperties.getSslConfig().isEnabled() || this.agentProperties.getServerUrl().startsWith("https")) {
            tmf = CertificateUtils.getTrustManagerFactory(this.agentProperties.getSslConfig().getCaCerts().getPassword());
        }
        this.initializeManagedChannel(tmf);
        this.initializeWebClient(tmf);
    }

    private void initializeManagedChannel(TrustManagerFactory tmf) {
        ManagedChannelBuilder channelBuilder;
        HeaderClientInterceptor interceptor = new HeaderClientInterceptor(this.agentProperties.getToken());
        RemoteAgentProperties.GrpcServer grpcServer = this.agentProperties.getGrpcServer();
        if (this.agentProperties.getSslConfig().isEnabled()) {
            this.log.info("gRPC SSL is enabled, connecting with secured channel");
            channelBuilder = Grpc.newChannelBuilderForAddress((String)grpcServer.getHost(), (int)grpcServer.getPort(), (ChannelCredentials)CertificateUtils.getChannelCredentials(tmf));
        } else {
            this.log.info("gRPC SSL is not enabled, connecting with plain text");
            channelBuilder = ManagedChannelBuilder.forAddress((String)grpcServer.getHost(), (int)grpcServer.getPort()).usePlaintext();
        }
        this.channel = channelBuilder.intercept(new ClientInterceptor[]{interceptor}).build();
    }

    private void initializeWebClient(TrustManagerFactory tmf) throws SSLException {
        WebClient.Builder webClientBuilder = WebClient.builder().baseUrl(this.agentProperties.getSanitizedServerUrl());
        if (this.agentProperties.getServerUrl().startsWith("https")) {
            this.log.info("SSL protocol found for Tomcat's REST url, configuring web client with SSL context");
            SslContext sslContext = CertificateUtils.getSslContext(tmf);
            HttpClient httpClient = HttpClient.create().secure(sslContextSpec -> sslContextSpec.sslContext(sslContext));
            webClientBuilder.clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient));
        } else {
            this.log.info("No SSL protocol found for Tomcat's REST url");
        }
        this.webClient = webClientBuilder.build();
    }

    @PreDestroy
    private void shutdown() {
        this.log.info("Shutting down ManagedChannel...");
        this.channel.shutdownNow();
    }

    public boolean verifyAgentToken() {
        ValidatorGrpc.ValidatorBlockingStub validatorBlockingStub = ValidatorGrpc.newBlockingStub((Channel)this.getChannel());
        TokenValidationRequest request = TokenValidationRequest.newBuilder().setToken(this.agentProperties.getToken()).setAgentName(this.agentProperties.getAgentName()).build();
        RemoteAgentProperties.GrpcServer grpcServer = this.agentProperties.getGrpcServer();
        this.log.info("Waiting for gRPC server [Host: {}, Port: {}] to be ready before validating agent credentials", (Object)grpcServer.getHost(), (Object)grpcServer.getPort());
        Response response = ((ValidatorGrpc.ValidatorBlockingStub)((ValidatorGrpc.ValidatorBlockingStub)validatorBlockingStub.withWaitForReady()).withDeadlineAfter(this.agentProperties.getGrpcServer().getTimeouts().getValidateAgentTokenRpc(), TimeUnit.SECONDS)).validateAgentToken(request);
        if (Response.ResponseStatus.RESPONSE_STATUS_SUCCESS.equals((Object)response.getStatus())) {
            return true;
        }
        this.log.error("Agent token validation failed: {}", (Object)response.getMessage());
        return false;
    }

    public String generateDownloadLink(String connectorId, String fileName, String docId, int lifeSpanInDays) {
        String uri = UriComponentsBuilder.fromUriString((String)this.getGenerateDownloadLinkEndpoint()).queryParam("connectorId", new Object[]{connectorId}).queryParam("docId", new Object[]{docId}).queryParam("lifeSpan", new Object[]{lifeSpanInDays}).queryParam("internal", new Object[]{false}).queryParam("fileName", new Object[]{fileName}).toUriString();
        try {
            String downloadLink = (String)this.getWebClient().get().uri(uri, new Object[0]).header("Authorization", new String[]{this.agentProperties.getToken()}).header("X-Agent-Name", new String[]{this.agentProperties.getAgentName()}).retrieve().bodyToMono(String.class).doOnError(e -> this.log.error("Error generating a download link for document {}", (Object)docId, e)).onErrorReturn((Object)"{}").block();
            JSONObject responseAsJson = new JSONObject(downloadLink);
            if (responseAsJson.getBoolean("success")) {
                return this.agentProperties.getSanitizedServerUrl() + this.getPublicDownloadEndpoint().replace("{key}", responseAsJson.getJSONObject("results").getString("key"));
            }
            this.log.error("Download link for document {} failed. Generated link was returned as: {}", (Object)docId, (Object)downloadLink);
        }
        catch (Exception e2) {
            this.log.error("Error creating download link for document {}", (Object)docId, (Object)e2);
        }
        return null;
    }

    public String getChunkedUploadEndpoint() {
        return CHUNKED_UPLOAD_ENDPOINT;
    }

    public String getCompleteFileUploadEndpoint() {
        return COMPLETE_FILE_UPLOAD_ENDPOINT;
    }

    public String getCancelFileUploadEndpoint() {
        return CANCEL_FILE_UPLOAD_ENDPOINT;
    }

    public String getDownloadFileBinariesEndpoint() {
        return DOWNLOAD_FILE_BINARIES_ENDPOINT;
    }

    public String getGenerateDownloadLinkEndpoint() {
        return GENERATE_DOWNLOAD_LINK_ENDPOINT;
    }

    public String getPublicDownloadEndpoint() {
        return PUBLIC_DOWNLOAD_ENDPOINT;
    }

    @Generated
    public CommunicationsManager(RemoteAgentProperties agentProperties) {
        this.agentProperties = agentProperties;
    }

    @Generated
    public ManagedChannel getChannel() {
        return this.channel;
    }

    @Generated
    public WebClient getWebClient() {
        return this.webClient;
    }
}

