/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.utils;

import com.objective.threesixty.Value;
import com.objective.threesixty.remoteagent.sdk.utils.ReservedIdentifier;
import com.objective.threesixty.remoteagent.sdk.utils.ValueUtils;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CustomParameters {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Map<String, Value> params;

    public boolean containsKey(String key) {
        return this.params.containsKey(key);
    }

    public Value get(String key) {
        return this.params.get(key);
    }

    public void put(String key, Value value) {
        this.params.put(key, value);
    }

    public Value getOrDefault(String key, Value defaultValue) {
        return this.params.getOrDefault(key, defaultValue);
    }

    public long getStartTimeOfDateFilter() {
        return this.params.getOrDefault(ReservedIdentifier.START_TIME.getName(), ValueUtils.longValue(Long.MIN_VALUE)).getLong();
    }

    public long getEndTimeOfDateFilter() {
        return this.params.getOrDefault(ReservedIdentifier.END_TIME.getName(), ValueUtils.longValue(Long.MAX_VALUE)).getLong();
    }

    public boolean getIncludeBinaries() {
        return this.params.getOrDefault(ReservedIdentifier.INCLUDE_BINARIES_PARAM.getName(), ValueUtils.booleanValue(false)).getBoolean();
    }

    public String getDocId() {
        return this.params.get(ReservedIdentifier.DOC_ID_PARAM.getName()).getString();
    }

    public boolean getIncludeHash() {
        return this.params.getOrDefault(ReservedIdentifier.INCLUDE_HASH_PARAM.getName(), ValueUtils.booleanValue(false)).getBoolean();
    }

    public int getMaxFileSizeHash() {
        int maxNtfsSizeMb = 0x10000000;
        return this.getIncludeHash() ? this.params.getOrDefault(ReservedIdentifier.MAX_FILE_SIZE_HASH.getName(), ValueUtils.intValue(maxNtfsSizeMb)).getInt() : 0;
    }

    public int getWriteDocumentTimeout() {
        return this.params.get(ReservedIdentifier.WRITE_DOCUMENT_TIMEOUT.getName()).getInt();
    }

    public boolean deleteAllVersions() {
        return this.params.getOrDefault(ReservedIdentifier.ALL_VERSIONS_PARAM.getName(), ValueUtils.booleanValue(false)).getBoolean();
    }

    public String removeString(String key) {
        if (this.params.get(key).hasString()) {
            return this.params.remove(key).getString();
        }
        this.log.warn("Expected a string value for key {}, but mapped Value was a non-string type", (Object)key);
        return null;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomParameters)) {
            return false;
        }
        CustomParameters other = (CustomParameters)o;
        Logger this$log = this.log;
        Logger other$log = other.log;
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        Map<String, Value> this$params = this.params;
        Map<String, Value> other$params = other.params;
        return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Logger $log = this.log;
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        Map<String, Value> $params = this.params;
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        return result;
    }

    @Generated
    public CustomParameters(Map<String, Value> params) {
        this.params = params;
    }
}

