/*
 * Decompiled with CFR 0.152.
 */
package com.okta.jwt.impl;

import com.okta.commons.lang.Assert;
import com.okta.jwt.Jwt;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultJwt
implements Jwt {
    private final String tokenValue;
    private final Map<String, Object> claims;
    private final Instant issuedAt;
    private final Instant expiresAt;

    public DefaultJwt(String tokenValue, Instant issuedAt, Instant expiresAt, Map<String, Object> claims) {
        Assert.notNull((Object)tokenValue, (String)"JWT token cannot be null");
        Assert.notNull((Object)issuedAt, (String)"issuedAt cannot be null");
        Assert.notNull((Object)expiresAt, (String)"expiresAt cannot be null");
        Assert.notEmpty(claims, (String)"claims cannot be empty");
        this.tokenValue = tokenValue;
        this.issuedAt = issuedAt;
        this.expiresAt = expiresAt;
        this.claims = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(claims));
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }
}

