/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import com.okta.spring.boot.oauth.AuthoritiesProvider;
import com.okta.spring.boot.oauth.UserUtil;
import java.util.Collection;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;

final class OktaOidcUserService
extends OidcUserService {
    private final Collection<AuthoritiesProvider> authoritiesProviders;

    OktaOidcUserService(OAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService, Collection<AuthoritiesProvider> authoritiesProviders) {
        this.authoritiesProviders = authoritiesProviders;
        this.setOauth2UserService(oauth2UserService);
    }

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser user = super.loadUser(userRequest);
        return UserUtil.decorateUser(user, userRequest, this.authoritiesProviders);
    }
}

