/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth.env;

import com.okta.spring.boot.oauth.env.RemappedPropertySource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

final class OktaOAuth2PropertiesMappingEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final String OKTA_OAUTH_PREFIX = "okta.oauth2.";
    private static final String OKTA_OAUTH_ISSUER = "okta.oauth2.issuer";
    private static final String OKTA_OAUTH_ISSUER_WITH_PATH = "okta.oauth2.issuer-with-path";
    private static final String OKTA_OAUTH_CLIENT_ID = "okta.oauth2.client-id";
    private static final String OKTA_OAUTH_CLIENT_SECRET = "okta.oauth2.client-secret";
    private static final String OKTA_OAUTH_SCOPES = "okta.oauth2.scopes";

    OktaOAuth2PropertiesMappingEnvironmentPostProcessor() {
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        environment.getPropertySources().addLast(this.remappedOktaToStandardOAuthPropertySource((Environment)environment));
        environment.getPropertySources().addLast(this.remappedOktaOAuth2ScopesPropertySource((Environment)environment));
        environment.getPropertySources().addLast(this.defaultOktaScopesSource((Environment)environment));
        environment.getPropertySources().addLast((PropertySource)new OktaIssuerWithPathPropertySource((Environment)environment));
        environment.getPropertySources().addLast(this.oktaStaticDiscoveryPropertySource((Environment)environment));
        environment.getPropertySources().addLast(this.oktaOpaqueTokenPropertySource((Environment)environment));
        environment.getPropertySources().addLast(this.oktaRedirectUriPropertySource((Environment)environment));
        environment.getPropertySources().addLast(this.otkaForcePkcePropertySource(environment));
    }

    private PropertySource<?> otkaForcePkcePropertySource(final ConfigurableEnvironment environment) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("spring.security.oauth2.client.registration.okta.client-authentication-method", "none");
        return new ConditionalMapPropertySource("okta-pkce-for-public-clients", props, (Environment)environment, new String[]{OKTA_OAUTH_ISSUER, OKTA_OAUTH_CLIENT_ID}){

            @Override
            public boolean containsProperty(String name) {
                return super.containsProperty(name) && !environment.containsProperty("spring.security.oauth2.client.registration.okta.client-secret");
            }
        };
    }

    private PropertySource defaultOktaScopesSource(Environment environment) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("spring.security.oauth2.client.registration.okta.scope", "profile,email,openid");
        return new ConditionalMapPropertySource("default-scopes", props, environment, new String[]{OKTA_OAUTH_ISSUER, OKTA_OAUTH_CLIENT_ID});
    }

    private PropertySource remappedOktaToStandardOAuthPropertySource(Environment environment) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        aliasMap.put("spring.security.oauth2.client.registration.okta.client-id", OKTA_OAUTH_CLIENT_ID);
        aliasMap.put("spring.security.oauth2.client.registration.okta.client-secret", OKTA_OAUTH_CLIENT_SECRET);
        return new RemappedPropertySource("okta-to-oauth2", aliasMap, environment);
    }

    private PropertySource remappedOktaOAuth2ScopesPropertySource(Environment environment) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("spring.security.oauth2.client.registration.okta.scope", "${okta.oauth2.scopes}");
        return new OktaScopesPropertySource("okta-scope-remaper", properties, environment);
    }

    private PropertySource oktaRedirectUriPropertySource(Environment environment) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("spring.security.oauth2.client.registration.okta.redirect-uri", "{baseUrl}${okta.oauth2.redirect-uri}");
        return new ConditionalMapPropertySource("okta-redirect-uri-helper", properties, environment, new String[]{"okta.oauth2.redirect-uri"});
    }

    private PropertySource oktaStaticDiscoveryPropertySource(Environment environment) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("spring.security.oauth2.resourceserver.jwt.issuer-uri", "${okta.oauth2.issuer}");
        properties.put("spring.security.oauth2.resourceserver.jwt.jwk-set-uri", "${okta.oauth2.issuer-with-path}/v1/keys");
        properties.put("spring.security.oauth2.client.provider.okta.authorization-uri", "${okta.oauth2.issuer-with-path}/v1/authorize");
        properties.put("spring.security.oauth2.client.provider.okta.token-uri", "${okta.oauth2.issuer-with-path}/v1/token");
        properties.put("spring.security.oauth2.client.provider.okta.user-info-uri", "${okta.oauth2.issuer-with-path}/v1/userinfo");
        properties.put("spring.security.oauth2.client.provider.okta.jwk-set-uri", "${okta.oauth2.issuer-with-path}/v1/keys");
        properties.put("spring.security.oauth2.client.provider.okta.issuer-uri", "${okta.oauth2.issuer}");
        return new ConditionalMapPropertySource("okta-static-discovery", properties, environment, new String[]{OKTA_OAUTH_ISSUER});
    }

    private PropertySource oktaOpaqueTokenPropertySource(Environment environment) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("spring.security.oauth2.resourceserver.opaque-token.client-id", "${okta.oauth2.client-id}");
        properties.put("spring.security.oauth2.resourceserver.opaque-token.client-secret", "${okta.oauth2.client-secret}");
        properties.put("spring.security.oauth2.resourceserver.opaque-token.introspection-uri", "${okta.oauth2.issuer}/v1/introspect");
        return new ConditionalMapPropertySource("okta-opaque-token", properties, environment, new String[]{OKTA_OAUTH_ISSUER, OKTA_OAUTH_CLIENT_SECRET});
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }

    private static class OktaIssuerWithPathPropertySource
    extends PropertySource<String> {
        private final Environment environment;

        private OktaIssuerWithPathPropertySource(Environment environment) {
            super("okta-issuer-url-resolving-source");
            this.environment = environment;
        }

        public Object getProperty(@NotNull String key) {
            if (OktaOAuth2PropertiesMappingEnvironmentPostProcessor.OKTA_OAUTH_ISSUER_WITH_PATH.equals(key)) {
                return Optional.ofNullable(this.environment.getProperty(OktaOAuth2PropertiesMappingEnvironmentPostProcessor.OKTA_OAUTH_ISSUER)).map(issuer -> {
                    if (!issuer.contains("/oauth2")) {
                        issuer = issuer + "/oauth2";
                    }
                    return issuer;
                }).orElse(null);
            }
            return null;
        }

        public boolean containsProperty(@NotNull String key) {
            return OktaOAuth2PropertiesMappingEnvironmentPostProcessor.OKTA_OAUTH_ISSUER_WITH_PATH.equals(key) && this.environment.containsProperty(OktaOAuth2PropertiesMappingEnvironmentPostProcessor.OKTA_OAUTH_ISSUER);
        }
    }

    private static class OktaScopesPropertySource
    extends MapPropertySource {
        private final Environment environment;

        private OktaScopesPropertySource(String name, Map<String, Object> source, Environment environment) {
            super(name, source);
            this.environment = environment;
        }

        public Object getProperty(String name) {
            if (this.containsProperty(name)) {
                return Binder.get((Environment)this.environment).bind(OktaOAuth2PropertiesMappingEnvironmentPostProcessor.OKTA_OAUTH_SCOPES, Bindable.setOf(String.class)).orElse(null);
            }
            return null;
        }
    }

    private static class ConditionalMapPropertySource
    extends MapPropertySource {
        private final Environment environment;
        private final List<String> conditionalProperties;

        private ConditionalMapPropertySource(String name, Map<String, Object> source, Environment environment, String ... conditionalProperties) {
            super(name, source);
            this.environment = environment;
            this.conditionalProperties = Arrays.asList(conditionalProperties);
        }

        public Object getProperty(String name) {
            return this.containsProperty(name) ? super.getProperty(name) : null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean containsProperty(String name) {
            if (!super.containsProperty(name)) return false;
            if (!this.conditionalProperties.stream().allMatch(arg_0 -> ((Environment)this.environment).containsProperty(arg_0))) return false;
            return true;
        }
    }
}

