/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.actors;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.Chain;
import oracle.ucp.util.ListChain;
import oracle.ucp.util.Pair;

public class InterruptableActor<R, D, E extends Throwable>
implements Diagnosable {
    static final String CLASS_NAME = InterruptableActor.class.getName();
    private static final int DEFAULT_AWAIT_TIMEOUT = 10;
    private static final int DEFAULT_POLL_COUNT = 10;
    private static final int DEFAULT_POLL_TIMEOUT = 1;
    private final int awaitTimeout;
    private final int pollCount;
    private final int pollTimeout;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final ListChain<Pair<Action<R, D, E>, Thread>> chain = new ListChain();
    private final AtomicReference<Predicate<Pair<Action<R, D, E>, Thread>>> predicate = new AtomicReference<Predicate<Pair>>(p -> false);
    private final Thread controlThread;
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();

    private Thread buildControlThread() {
        return new Thread(() -> {
            block7: while (true) {
                try {
                    this.lock.lock();
                    this.condition.await(this.awaitTimeout, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    this.trace(Level.WARNING, CLASS_NAME, "buildControlThread", "", null, e, new Object[0]);
                }
                finally {
                    this.lock.unlock();
                }
                int i = 0;
                while (true) {
                    if (i >= this.pollCount) continue block7;
                    this.interruptAllAppropriateActions();
                    try {
                        Thread.sleep((long)this.pollTimeout * 1000L);
                    }
                    catch (InterruptedException e) {
                        this.trace(Level.WARNING, CLASS_NAME, "buildControlThread", "", null, e, new Object[0]);
                    }
                    ++i;
                }
                break;
            }
        }, InterruptableActor.class.getName() + "-control");
    }

    private void interruptAllAppropriateActions() {
        this.chain.forEach(p -> {
            if (this.predicate.get().test((Pair<Action<R, D, E>, Thread>)p)) {
                this.trace(Level.FINEST, CLASS_NAME, "interruptAllAppropriateActions", "about to interrupt: {0}", null, null, p.get2nd());
                ((Thread)p.get2nd()).interrupt();
            }
        });
    }

    public InterruptableActor(int awaitTimeout, int pollCount, int pollTimeout, Diagnosable diagnosticsCollector) {
        this.awaitTimeout = awaitTimeout;
        this.pollCount = pollCount;
        this.pollTimeout = pollTimeout;
        this.controlThread = this.buildControlThread();
        this.controlThread.setDaemon(true);
        this.controlThread.start();
        this.diagnosticsCollector = Objects.requireNonNull(diagnosticsCollector);
    }

    public InterruptableActor(Diagnosable diagnosticsCollector) {
        this(10, 10, 1, diagnosticsCollector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public R doAction(Action<R, D, E> action) throws E {
        try {
            Object r;
            void action2;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.actors.InterruptableActor", "doAction", "entering args ({0})", null, null, action);
            Chain.Atom atom = this.chain.add(new Pair<void, Thread>(action2, Thread.currentThread()));
            try {
                Object r2 = action2.exec();
                r = r2;
            }
            catch (InterruptedException e) {
                this.trace(Level.WARNING, CLASS_NAME, "doAction", "", null, e, new Object[0]);
                R r3 = null;
                R r4 = r3;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.actors.InterruptableActor", "doAction", "returning {0}", null, null, r4);
                return r4;
            }
            finally {
                ((ListChain.Atom)atom).remove();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.actors.InterruptableActor", "doAction", "returning {0}", null, null, r);
            return r;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.actors.InterruptableActor", "doAction", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public void registerPredicate(Predicate<Pair<Action<R, D, E>, Thread>> predicate) {
        try {
            void predicate2;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.actors.InterruptableActor", "registerPredicate", "entering args ({0})", null, null, predicate);
            this.predicate.set((Predicate<Pair<Action<R, D, E>, Thread>>)predicate2);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.actors.InterruptableActor", "registerPredicate", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.actors.InterruptableActor", "registerPredicate", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    public void triggerInterrupts() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.actors.InterruptableActor", "triggerInterrupts", "entering args ()", null, null, new Object[0]);
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.actors.InterruptableActor", "triggerInterrupts", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.actors.InterruptableActor", "triggerInterrupts", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }

    public static interface Action<R, D, E extends Throwable> {
        public R exec() throws InterruptedException, E;

        default public D getDescriptor() {
            return null;
        }
    }
}

