/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.java;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.javaformat.OpsBuilder;
import com.palantir.javaformat.java.InputMetadata;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="InputMetadata", generator="Immutables")
@Immutable
public final class ImmutableInputMetadata
implements InputMetadata {
    private final ImmutableMap<Integer, OpsBuilder.BlankLineWanted> blankLines;
    private final ImmutableRangeSet<Integer> partialFormatRanges;

    private ImmutableInputMetadata(Builder builder) {
        this.blankLines = builder.blankLines.build();
        this.partialFormatRanges = builder.partialFormatRanges != null ? builder.partialFormatRanges : Objects.requireNonNull(InputMetadata.super.partialFormatRanges(), "partialFormatRanges");
    }

    private ImmutableInputMetadata(ImmutableMap<Integer, OpsBuilder.BlankLineWanted> blankLines, ImmutableRangeSet<Integer> partialFormatRanges) {
        this.blankLines = blankLines;
        this.partialFormatRanges = partialFormatRanges;
    }

    @Override
    public ImmutableMap<Integer, OpsBuilder.BlankLineWanted> blankLines() {
        return this.blankLines;
    }

    @Override
    public ImmutableRangeSet<Integer> partialFormatRanges() {
        return this.partialFormatRanges;
    }

    public final ImmutableInputMetadata withBlankLines(Map<Integer, ? extends OpsBuilder.BlankLineWanted> entries) {
        if (this.blankLines == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableInputMetadata((ImmutableMap<Integer, OpsBuilder.BlankLineWanted>)newValue, this.partialFormatRanges);
    }

    public final ImmutableInputMetadata withPartialFormatRanges(ImmutableRangeSet<Integer> value) {
        if (this.partialFormatRanges == value) {
            return this;
        }
        ImmutableRangeSet<Integer> newValue = Objects.requireNonNull(value, "partialFormatRanges");
        return new ImmutableInputMetadata(this.blankLines, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInputMetadata && this.equalTo((ImmutableInputMetadata)another);
    }

    private boolean equalTo(ImmutableInputMetadata another) {
        return this.blankLines.equals(another.blankLines) && this.partialFormatRanges.equals(another.partialFormatRanges);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.blankLines.hashCode();
        h += (h << 5) + this.partialFormatRanges.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"InputMetadata").omitNullValues().add("blankLines", this.blankLines).add("partialFormatRanges", this.partialFormatRanges).toString();
    }

    public static InputMetadata copyOf(InputMetadata instance) {
        if (instance instanceof ImmutableInputMetadata) {
            return (ImmutableInputMetadata)instance;
        }
        return ImmutableInputMetadata.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InputMetadata", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableMap.Builder<Integer, OpsBuilder.BlankLineWanted> blankLines = ImmutableMap.builder();
        @Nullable
        private ImmutableRangeSet<Integer> partialFormatRanges;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(InputMetadata instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllBlankLines((Map<Integer, ? extends OpsBuilder.BlankLineWanted>)instance.blankLines());
            this.partialFormatRanges(instance.partialFormatRanges());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putBlankLines(int key, OpsBuilder.BlankLineWanted value) {
            this.blankLines.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putBlankLines(Map.Entry<Integer, ? extends OpsBuilder.BlankLineWanted> entry) {
            this.blankLines.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder blankLines(Map<Integer, ? extends OpsBuilder.BlankLineWanted> entries) {
            this.blankLines = ImmutableMap.builder();
            return this.putAllBlankLines(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllBlankLines(Map<Integer, ? extends OpsBuilder.BlankLineWanted> entries) {
            this.blankLines.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder partialFormatRanges(ImmutableRangeSet<Integer> partialFormatRanges) {
            this.partialFormatRanges = Objects.requireNonNull(partialFormatRanges, "partialFormatRanges");
            return this;
        }

        public InputMetadata build() {
            return new ImmutableInputMetadata(this);
        }
    }
}

