/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.common.operations;

import com.playtika.test.common.operations.NetworkTestOperations;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.common.utils.ThrowingRunnable;
import java.time.Duration;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.containers.GenericContainer;

public class DefaultNetworkTestOperations
implements NetworkTestOperations {
    private static final Logger log = LoggerFactory.getLogger(DefaultNetworkTestOperations.class);
    private final GenericContainer targetContainer;

    @Override
    public void addNetworkLatencyForResponses(Duration delay) {
        ContainerUtils.executeAndCheckExitCode((ContainerState)this.targetContainer, "tc", "qdisc", "add", "dev", "eth0", "root", "netem", "delay", delay.toMillis() + "ms");
    }

    @Override
    public void removeNetworkLatencyForResponses() {
        ContainerUtils.executeAndCheckExitCode((ContainerState)this.targetContainer, "tc", "qdisc", "del", "dev", "eth0", "root");
    }

    @Override
    public void withNetworkLatency(Duration delay, ThrowingRunnable runnable) {
        try {
            this.addNetworkLatencyForResponses(delay);
            runnable.run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.removeNetworkLatencyForResponses();
        }
    }

    @Override
    public <T> T withNetworkLatency(Duration delay, Callable<T> callable) {
        try {
            this.addNetworkLatencyForResponses(delay);
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.removeNetworkLatencyForResponses();
        }
    }

    public DefaultNetworkTestOperations(GenericContainer targetContainer) {
        this.targetContainer = targetContainer;
    }
}

