/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field13D
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "13D";
    public static final String F_13D = "13D";
    public static final Integer DATE = 1;
    public static final Integer TIME = 2;
    public static final Integer SIGN = 3;
    public static final Integer OFFSET = 4;

    public Field13D() {
        super(4);
    }

    public Field13D(String value) {
        super(value);
    }

    public Field13D(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"13D")) {
            throw new IllegalArgumentException("cannot create field 13D from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field13D newInstance(Field13D source) {
        Field13D cp = new Field13D();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("13D", value);
    }

    public static Tag emptyTag() {
        return new Tag("13D", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        if (value != null) {
            if (value.length() >= 6) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)6));
            }
            if (value.length() >= 10) {
                this.setComponent2(StringUtils.substring((String)value, (int)6, (int)10));
            }
            if (value.length() >= 11) {
                this.setComponent3(StringUtils.substring((String)value, (int)10, (int)11));
            }
            if (value.length() > 11) {
                this.setComponent4(StringUtils.substring((String)value, (int)11));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 13D");
        }
        if (component == 1) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 2) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return this.getComponent(4);
    }

    @Override
    public String typesPattern() {
        return "EHGO";
    }

    @Override
    public String parserPattern() {
        return "<DATE2><HHMM><SIGN><OFFSET>";
    }

    @Override
    public String validatorPattern() {
        return "<DATE2><HHMM><SIGN><OFFSET>";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Date");
        result.add("Time");
        result.add("Sign");
        result.add("Offset");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "date");
        result.put(2, "time");
        result.put(3, "sign");
        result.put(4, "offset");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("date", 1);
        this.labelMap.put("time", 2);
        this.labelMap.put("sign", 3);
        this.labelMap.put("offset", 4);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(1));
    }

    public String getDate() {
        return this.getComponent1();
    }

    public Calendar getDateAsCalendar() {
        return this.getComponent1AsCalendar();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(2));
    }

    public String getTime() {
        return this.getComponent2();
    }

    public Calendar getTimeAsCalendar() {
        return this.getComponent2AsCalendar();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getSign() {
        return this.getComponent3();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Calendar getComponent4AsCalendar() {
        return SwiftFormatUtils.getOffset(this.getComponent(4));
    }

    public String getOffset() {
        return this.getComponent4();
    }

    public Calendar getOffsetAsCalendar() {
        return this.getComponent4AsCalendar();
    }

    public Field13D setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field13D setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate2(component1));
        return this;
    }

    public Field13D setDate(String component1) {
        return this.setComponent1(component1);
    }

    public Field13D setDate(Calendar component1) {
        return this.setComponent1(component1);
    }

    public Field13D setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field13D setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getTime3(component2));
        return this;
    }

    public Field13D setTime(String component2) {
        return this.setComponent2(component2);
    }

    public Field13D setTime(Calendar component2) {
        return this.setComponent2(component2);
    }

    public Field13D setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field13D setSign(String component3) {
        return this.setComponent3(component3);
    }

    public Field13D setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field13D setComponent4(Calendar component4) {
        this.setComponent(4, SwiftFormatUtils.getOffset(component4));
        return this;
    }

    public Field13D setOffset(String component4) {
        return this.setComponent4(component4);
    }

    public Field13D setOffset(Calendar component4) {
        return this.setComponent4(component4);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getName() {
        return "13D";
    }

    public static Field13D get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("13D");
        if (t == null) {
            return null;
        }
        return new Field13D(t);
    }

    public static Field13D get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field13D.get(msg.getBlock4());
    }

    public static List<Field13D> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field13D.getAll(msg.getBlock4());
    }

    public static List<Field13D> getAll(SwiftTagListBlock block) {
        ArrayList<Field13D> result = new ArrayList<Field13D>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("13D");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field13D(f));
            }
        }
        return result;
    }

    public static Field13D fromJson(String json) {
        Field13D field = new Field13D();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("date") != null) {
            field.setComponent1(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("time") != null) {
            field.setComponent2(jsonObject.get("time").getAsString());
        }
        if (jsonObject.get("sign") != null) {
            field.setComponent3(jsonObject.get("sign").getAsString());
        }
        if (jsonObject.get("offset") != null) {
            field.setComponent4(jsonObject.get("offset").getAsString());
        }
        return field;
    }
}

