/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field25D
extends Field
implements Serializable,
GenericField {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "25D";
    public static final String F_25D = "25D";
    public static final Integer QUALIFIER = 1;
    public static final Integer DATA_SOURCE_SCHEME = 2;
    public static final Integer STATUS_CODE = 3;
    public static final Integer CONDITIONAL_QUALIFIER = 3;

    public Field25D() {
        super(3);
    }

    public Field25D(String value) {
        super(value);
    }

    public Field25D(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"25D")) {
            throw new IllegalArgumentException("cannot create field 25D from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field25D newInstance(Field25D source) {
        Field25D cp = new Field25D();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("25D", value);
    }

    public static Tag emptyTag() {
        return new Tag("25D", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
        this.setComponent3(SwiftParseUtils.getTokenThirdLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 25D");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return this.getComponent(3);
    }

    @Override
    public String typesPattern() {
        return "SSS";
    }

    @Override
    public String parserPattern() {
        return ":S/[S]/S";
    }

    @Override
    public String validatorPattern() {
        return ":4!c/[8c]/4!c";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Data Source Scheme");
        result.add("Status Code");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "dataSourceScheme");
        result.put(3, "statusCode");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("datasourcescheme", 2);
        this.labelMap.put("statuscode", 3);
        this.labelMap.put("code", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getDataSourceScheme() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getStatusCode() {
        return this.getComponent3();
    }

    public Field25D setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field25D setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field25D setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field25D setDataSourceScheme(String component2) {
        return this.setComponent2(component2);
    }

    public Field25D setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field25D setStatusCode(String component3) {
        return this.setComponent3(component3);
    }

    @Override
    public String getDSS() {
        return this.getComponent2();
    }

    @Override
    public boolean isDSSPresent() {
        return this.getComponent2() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "25D";
    }

    public static Field25D get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("25D");
        if (t == null) {
            return null;
        }
        return new Field25D(t);
    }

    public static Field25D get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field25D.get(msg.getBlock4());
    }

    public static List<Field25D> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field25D.getAll(msg.getBlock4());
    }

    public static List<Field25D> getAll(SwiftTagListBlock block) {
        ArrayList<Field25D> result = new ArrayList<Field25D>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("25D");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field25D(f));
            }
        }
        return result;
    }

    public static Field25D fromJson(String json) {
        Field25D field = new Field25D();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("dataSourceScheme") != null) {
            field.setComponent2(jsonObject.get("dataSourceScheme").getAsString());
        }
        if (jsonObject.get("code") != null) {
            field.setComponent3(jsonObject.get("code").getAsString());
        }
        if (jsonObject.get("statusCode") != null) {
            field.setComponent3(jsonObject.get("statusCode").getAsString());
        }
        return field;
    }
}

