/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field340
extends Field
implements Serializable {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "340";
    public static final String F_340 = "340";
    public static final Integer COUNTRY_CODE = 1;
    public static final Integer DATES = 2;

    public Field340() {
        super(2);
    }

    public Field340(String value) {
        super(value);
    }

    public Field340(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"340")) {
            throw new IllegalArgumentException("cannot create field 340 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field340 newInstance(Field340 source) {
        Field340 cp = new Field340();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("340", value);
    }

    public static Tag emptyTag() {
        return new Tag("340", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        if (value != null && value.length() >= 2) {
            this.setComponent1(StringUtils.substring((String)value, (int)0, (int)2));
            if (value.length() > 2) {
                this.setComponent2(StringUtils.substring((String)value, (int)2));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 340");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        return this.getComponent(2);
    }

    @Override
    public String typesPattern() {
        return "KS";
    }

    @Override
    public String parserPattern() {
        return "<CC>S";
    }

    @Override
    public String validatorPattern() {
        return "<CC>[14<DATE1>]";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Country Code");
        result.add("Dates");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "countryCode");
        result.put(2, "dates");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("countrycode", 1);
        this.labelMap.put("dates", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getCountryCode() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getDates() {
        return this.getComponent2();
    }

    public Field340 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field340 setCountryCode(String component1) {
        return this.setComponent1(component1);
    }

    public Field340 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field340 setDates(String component2) {
        return this.setComponent2(component2);
    }

    @Override
    public String getName() {
        return "340";
    }

    public static Field340 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("340");
        if (t == null) {
            return null;
        }
        return new Field340(t);
    }

    public static Field340 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field340.get(msg.getBlock4());
    }

    public static List<Field340> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field340.getAll(msg.getBlock4());
    }

    public static List<Field340> getAll(SwiftTagListBlock block) {
        ArrayList<Field340> result = new ArrayList<Field340>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("340");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field340(f));
            }
        }
        return result;
    }

    public static Field340 fromJson(String json) {
        Field340 field = new Field340();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("countryCode") != null) {
            field.setComponent1(jsonObject.get("countryCode").getAsString());
        }
        if (jsonObject.get("dates") != null) {
            field.setComponent2(jsonObject.get("dates").getAsString());
        }
        return field;
    }
}

