/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.blocks.LeftCurlyOption;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.Locale;
import javax.annotation.Nullable;

@StatelessCheck
public class LeftCurlyCheck
extends AbstractCheck {
    public static final String MSG_KEY_LINE_NEW = "line.new";
    public static final String MSG_KEY_LINE_PREVIOUS = "line.previous";
    public static final String MSG_KEY_LINE_BREAK_AFTER = "line.break.after";
    private static final String OPEN_CURLY_BRACE = "{";
    private boolean ignoreEnums = true;
    private LeftCurlyOption option = LeftCurlyOption.EOL;

    public void setOption(String optionStr) {
        this.option = LeftCurlyOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
    }

    public void setIgnoreEnums(boolean ignoreEnums) {
        this.ignoreEnums = ignoreEnums;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{157, 14, 8, 155, 154, 15, 181, 93, 96, 94, 85, 92, 97, 91, 83, 89, 67, 95, 84, 9, 6, 12, 199, 203};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST brace;
        DetailAST startToken;
        switch (ast.getType()) {
            case 8: 
            case 9: 
            case 203: {
                startToken = LeftCurlyCheck.skipModifierAnnotations(ast);
                DetailAST detailAST = ast.findFirstToken(7);
                break;
            }
            case 14: 
            case 15: 
            case 154: 
            case 155: 
            case 157: 
            case 199: {
                startToken = LeftCurlyCheck.skipModifierAnnotations(ast);
                DetailAST detailAST = ast.findFirstToken(6);
                break;
            }
            case 12: 
            case 67: 
            case 83: 
            case 84: 
            case 85: 
            case 91: 
            case 95: 
            case 96: 
            case 97: 
            case 181: {
                startToken = ast;
                DetailAST detailAST = ast.findFirstToken(7);
                break;
            }
            case 92: {
                startToken = ast;
                DetailAST detailAST = LeftCurlyCheck.getBraceAsFirstChild(ast);
                break;
            }
            case 93: 
            case 94: {
                startToken = ast;
                DetailAST detailAST = LeftCurlyCheck.getBraceFromSwitchMember(ast);
                break;
            }
            default: {
                startToken = ast;
                DetailAST detailAST = brace = ast.findFirstToken(72);
            }
        }
        if (brace != null) {
            this.verifyBrace(brace, startToken);
        }
    }

    @Nullable
    private static DetailAST getBraceFromSwitchMember(DetailAST ast) {
        DetailAST parent = ast.getParent();
        DetailAST brace = parent.getType() == 208 ? parent.findFirstToken(7) : LeftCurlyCheck.getBraceAsFirstChild(ast.getNextSibling());
        return brace;
    }

    @Nullable
    private static DetailAST getBraceAsFirstChild(DetailAST ast) {
        DetailAST candidate;
        DetailAST brace = null;
        if (ast != null && (candidate = ast.getFirstChild()) != null && candidate.getType() == 7) {
            brace = candidate;
        }
        return brace;
    }

    private static DetailAST skipModifierAnnotations(DetailAST ast) {
        DetailAST lastAnnotation;
        DetailAST resultNode = ast;
        DetailAST modifiers = ast.findFirstToken(5);
        if (modifiers != null && (lastAnnotation = LeftCurlyCheck.findLastAnnotation(modifiers)) != null) {
            resultNode = lastAnnotation.getNextSibling() == null ? modifiers.getNextSibling() : lastAnnotation.getNextSibling();
        }
        return resultNode;
    }

    private static DetailAST findLastAnnotation(DetailAST modifiers) {
        DetailAST annotation;
        for (annotation = modifiers.findFirstToken(159); annotation != null && annotation.getNextSibling() != null && annotation.getNextSibling().getType() == 159; annotation = annotation.getNextSibling()) {
        }
        return annotation;
    }

    private void verifyBrace(DetailAST brace, DetailAST startToken) {
        String braceLine = this.getLine(brace.getLineNo() - 1);
        if (braceLine.length() <= brace.getColumnNo() + 1 || braceLine.charAt(brace.getColumnNo() + 1) != '}') {
            if (this.option == LeftCurlyOption.NL) {
                if (!CommonUtil.hasWhitespaceBefore(brace.getColumnNo(), braceLine)) {
                    this.log(brace, MSG_KEY_LINE_NEW, OPEN_CURLY_BRACE, brace.getColumnNo() + 1);
                }
            } else if (this.option == LeftCurlyOption.EOL) {
                this.validateEol(brace, braceLine);
            } else if (!TokenUtil.areOnSameLine(startToken, brace)) {
                this.validateNewLinePosition(brace, startToken, braceLine);
            }
        }
    }

    private void validateEol(DetailAST brace, String braceLine) {
        if (CommonUtil.hasWhitespaceBefore(brace.getColumnNo(), braceLine)) {
            this.log(brace, MSG_KEY_LINE_PREVIOUS, OPEN_CURLY_BRACE, brace.getColumnNo() + 1);
        }
        if (!this.hasLineBreakAfter(brace)) {
            this.log(brace, MSG_KEY_LINE_BREAK_AFTER, OPEN_CURLY_BRACE, brace.getColumnNo() + 1);
        }
    }

    private void validateNewLinePosition(DetailAST brace, DetailAST startToken, String braceLine) {
        if (startToken.getLineNo() + 1 == brace.getLineNo()) {
            if (CommonUtil.hasWhitespaceBefore(brace.getColumnNo(), braceLine)) {
                this.log(brace, MSG_KEY_LINE_PREVIOUS, OPEN_CURLY_BRACE, brace.getColumnNo() + 1);
            } else {
                this.log(brace, MSG_KEY_LINE_NEW, OPEN_CURLY_BRACE, brace.getColumnNo() + 1);
            }
        } else if (!CommonUtil.hasWhitespaceBefore(brace.getColumnNo(), braceLine)) {
            this.log(brace, MSG_KEY_LINE_NEW, OPEN_CURLY_BRACE, brace.getColumnNo() + 1);
        }
    }

    private boolean hasLineBreakAfter(DetailAST leftCurly) {
        DetailAST nextToken = null;
        if (leftCurly.getType() == 7) {
            nextToken = leftCurly.getFirstChild();
        } else if (!this.ignoreEnums && leftCurly.getParent().getParent().getType() == 154) {
            nextToken = leftCurly.getNextSibling();
        }
        return nextToken == null || nextToken.getType() == 73 || !TokenUtil.areOnSameLine(leftCurly, nextToken);
    }
}

