/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.header;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.PropertyType;
import com.puppycrawl.tools.checkstyle.XdocsPropertyType;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.ExternalResourceHolder;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;

@FileStatefulCheck
public class MultiFileRegexpHeaderCheck
extends AbstractFileSetCheck
implements ExternalResourceHolder {
    public static final int MISMATCH_CODE = -1;
    public static final String MSG_HEADER_MISSING = "multi.file.regexp.header.missing";
    public static final String MSG_HEADER_MISMATCH = "multi.file.regexp.header.mismatch";
    private static final String EMPTY_LINE_PATTERN = "^$";
    private static final Pattern BLANK_LINE = Pattern.compile("^$");
    private final List<HeaderFileMetadata> headerFilesMetadata = new ArrayList<HeaderFileMetadata>();
    @XdocsPropertyType(value=PropertyType.STRING)
    private String headerFiles;

    public void setHeaderFiles(String ... headerFiles) {
        String[] files = headerFiles == null ? CommonUtil.EMPTY_STRING_ARRAY : (String[])headerFiles.clone();
        this.headerFilesMetadata.clear();
        for (String headerFile : files) {
            this.headerFilesMetadata.add(HeaderFileMetadata.createFromFile(headerFile));
        }
    }

    public String getConfiguredHeaderPaths() {
        return this.headerFilesMetadata.stream().map(HeaderFileMetadata::getHeaderFilePath).collect(Collectors.joining(", "));
    }

    @Override
    public Set<String> getExternalResourceLocations() {
        return this.headerFilesMetadata.stream().map(HeaderFileMetadata::getHeaderFileUri).map(URI::toASCIIString).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    protected void processFiltered(File file, FileText fileText) {
        List<MatchResult> matchResult;
        if (!this.headerFilesMetadata.isEmpty() && (matchResult = this.headerFilesMetadata.stream().map(headerFile -> MultiFileRegexpHeaderCheck.matchHeader(fileText, headerFile)).toList()).stream().noneMatch(match -> match.isMatching)) {
            MatchResult mismatch = matchResult.get(0);
            String allConfiguredHeaderPaths = this.getConfiguredHeaderPaths();
            this.log(mismatch.lineNumber, mismatch.messageKey, mismatch.messageArg, allConfiguredHeaderPaths);
        }
    }

    private static MatchResult matchHeader(FileText fileText, HeaderFileMetadata headerFile) {
        int index;
        int fileSize = fileText.size();
        List<Pattern> headerPatterns = headerFile.getHeaderPatterns();
        int headerPatternSize = headerPatterns.size();
        int mismatchLine = -1;
        for (index = 0; index < headerPatternSize && index < fileSize; ++index) {
            if (headerPatterns.get(index).matcher(fileText.get(index)).find()) continue;
            mismatchLine = index;
            break;
        }
        if (index < headerPatternSize) {
            mismatchLine = index;
        }
        MatchResult matchResult = mismatchLine == -1 ? MatchResult.matching() : MultiFileRegexpHeaderCheck.createMismatchResult(headerFile, fileText, mismatchLine);
        return matchResult;
    }

    private static MatchResult createMismatchResult(HeaderFileMetadata headerFile, FileText fileText, int mismatchLine) {
        String messageArg;
        int lineToLog;
        String messageKey;
        if (headerFile.getHeaderPatterns().size() > fileText.size()) {
            messageKey = MSG_HEADER_MISSING;
            lineToLog = 1;
            messageArg = headerFile.getHeaderFilePath();
        } else {
            messageKey = MSG_HEADER_MISMATCH;
            lineToLog = mismatchLine + 1;
            String lineContent = headerFile.getLineContents().get(mismatchLine);
            messageArg = lineContent.isEmpty() ? EMPTY_LINE_PATTERN : lineContent;
        }
        return MatchResult.mismatch(lineToLog, messageKey, messageArg);
    }

    public static List<String> getLines(String headerFile, URI uri) {
        ArrayList<String> readerLines = new ArrayList<String>();
        try (LineNumberReader lineReader = new LineNumberReader(new InputStreamReader((InputStream)new BufferedInputStream(uri.toURL().openStream()), StandardCharsets.UTF_8));){
            String line;
            do {
                if ((line = lineReader.readLine()) == null) continue;
                readerLines.add(line);
            } while (line != null);
        }
        catch (IOException exc) {
            throw new IllegalArgumentException("unable to load header file " + headerFile, exc);
        }
        if (readerLines.isEmpty()) {
            throw new IllegalArgumentException("Header file is empty: " + headerFile);
        }
        return readerLines;
    }

    private static final class HeaderFileMetadata {
        private final URI headerFileUri;
        private final String headerFilePath;
        private final List<Pattern> headerPatterns;
        private final List<String> lineContents;

        private HeaderFileMetadata(URI headerFileUri, String headerFilePath, List<Pattern> headerPatterns, List<String> lineContents) {
            this.headerFileUri = headerFileUri;
            this.headerFilePath = headerFilePath;
            this.headerPatterns = headerPatterns;
            this.lineContents = lineContents;
        }

        public static HeaderFileMetadata createFromFile(String headerPath) {
            if (CommonUtil.isBlank(headerPath)) {
                throw new IllegalArgumentException("Header file is not set");
            }
            try {
                URI uri = CommonUtil.getUriByFilename(headerPath);
                List<String> readerLines = MultiFileRegexpHeaderCheck.getLines(headerPath, uri);
                List<Pattern> patterns = readerLines.stream().map(HeaderFileMetadata::createPatternFromLine).toList();
                return new HeaderFileMetadata(uri, headerPath, patterns, readerLines);
            }
            catch (CheckstyleException exc) {
                throw new IllegalArgumentException("Error reading or corrupted header file: " + headerPath, exc);
            }
        }

        private static Pattern createPatternFromLine(String line) {
            Pattern result = line.isEmpty() ? BLANK_LINE : Pattern.compile(HeaderFileMetadata.validateRegex(line));
            return result;
        }

        public URI getHeaderFileUri() {
            return this.headerFileUri;
        }

        public String getHeaderFilePath() {
            return this.headerFilePath;
        }

        public List<Pattern> getHeaderPatterns() {
            return List.copyOf(this.headerPatterns);
        }

        public List<String> getLineContents() {
            return List.copyOf(this.lineContents);
        }

        private static String validateRegex(String input) {
            try {
                Pattern.compile(input);
                return input;
            }
            catch (PatternSyntaxException exc) {
                throw new IllegalArgumentException("Invalid regex pattern: " + input, exc);
            }
        }
    }

    private static final class MatchResult {
        private final boolean isMatching;
        private final int lineNumber;
        private final String messageKey;
        private final String messageArg;

        private MatchResult(boolean isMatching, int lineNumber, String messageKey, String messageArg) {
            this.isMatching = isMatching;
            this.lineNumber = lineNumber;
            this.messageKey = messageKey;
            this.messageArg = messageArg;
        }

        public static MatchResult matching() {
            return new MatchResult(true, 0, null, null);
        }

        public static MatchResult mismatch(int lineNumber, String messageKey, String messageArg) {
            return new MatchResult(false, lineNumber, messageKey, messageArg);
        }
    }
}

