/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.SortedMap;
import java.util.TreeMap;

public class DetailAstSet {
    private final IndentationCheck indentCheck;
    private final SortedMap<Integer, DetailAST> astLines = new TreeMap<Integer, DetailAST>();

    public DetailAstSet(IndentationCheck indentCheck) {
        this.indentCheck = indentCheck;
    }

    public void addAst(DetailAST ast) {
        this.addLineWithAst(ast.getLineNo(), ast);
    }

    private void addLineWithAst(int lineNo, DetailAST ast) {
        this.astLines.put(lineNo, ast);
    }

    public Integer getStartColumn(int lineNum) {
        Integer startColumn = null;
        DetailAST ast = this.getAst(lineNum);
        if (ast != null) {
            startColumn = this.expandedTabsColumnNo(ast);
        }
        return startColumn;
    }

    public boolean isEmpty() {
        return this.astLines.isEmpty();
    }

    public DetailAST firstLine() {
        return (DetailAST)this.astLines.get(this.astLines.firstKey());
    }

    public DetailAST getAst(int lineNum) {
        return (DetailAST)this.astLines.get(lineNum);
    }

    public Integer lastLine() {
        return this.astLines.lastKey();
    }

    protected final int expandedTabsColumnNo(DetailAST ast) {
        String line = this.indentCheck.getLine(ast.getLineNo() - 1);
        return CommonUtil.lengthExpandedTabs(line, ast.getColumnNo(), this.indentCheck.getIndentationTabWidth());
    }
}

