/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.Consumer;
import com.rabbitmq.client.amqp.ConsumerBuilder;
import com.rabbitmq.client.amqp.Resource;
import com.rabbitmq.client.amqp.impl.AmqpConnection;
import com.rabbitmq.client.amqp.impl.Assert;
import com.rabbitmq.client.amqp.impl.Utils;
import com.rabbitmq.qpid.protonj2.types.Binary;
import com.rabbitmq.qpid.protonj2.types.Decimal128;
import com.rabbitmq.qpid.protonj2.types.Decimal32;
import com.rabbitmq.qpid.protonj2.types.Decimal64;
import com.rabbitmq.qpid.protonj2.types.DescribedType;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnknownDescribedType;
import com.rabbitmq.qpid.protonj2.types.UnsignedByte;
import com.rabbitmq.qpid.protonj2.types.UnsignedInteger;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.UnsignedShort;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

class AmqpConsumerBuilder
implements ConsumerBuilder {
    static ConsumerBuilder.SubscriptionListener NO_OP_SUBSCRIPTION_LISTENER = ctx -> {};
    private final AmqpConnection connection;
    private String queue;
    private boolean directReplyTo = false;
    private Consumer.MessageHandler messageHandler;
    private int initialCredits = 100;
    private final List<Resource.StateListener> listeners = new ArrayList<Resource.StateListener>();
    private final Map<String, DescribedType> filters = new LinkedHashMap<String, DescribedType>();
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private final ConsumerBuilder.StreamOptions streamOptions = new DefaultStreamOptions(this, this.filters);
    private ConsumerBuilder.SubscriptionListener subscriptionListener = NO_OP_SUBSCRIPTION_LISTENER;

    AmqpConsumerBuilder(AmqpConnection connection) {
        this.connection = connection;
    }

    @Override
    public ConsumerBuilder queue(String queue) {
        this.queue = queue;
        this.directReplyTo = this.queue == null;
        return this;
    }

    ConsumerBuilder directReplyTo(boolean directReplyTo) {
        this.directReplyTo = directReplyTo;
        if (this.directReplyTo) {
            this.queue = null;
        }
        return this;
    }

    @Override
    public ConsumerBuilder messageHandler(Consumer.MessageHandler handler) {
        this.messageHandler = handler;
        return this;
    }

    @Override
    public ConsumerBuilder initialCredits(int initialCredits) {
        this.initialCredits = initialCredits;
        return this;
    }

    @Override
    public ConsumerBuilder priority(int priority) {
        this.properties.put("rabbitmq:priority", priority);
        return this;
    }

    @Override
    public ConsumerBuilder listeners(Resource.StateListener ... listeners) {
        if (listeners == null || listeners.length == 0) {
            this.listeners.clear();
        } else {
            this.listeners.addAll(List.of(listeners));
        }
        return this;
    }

    @Override
    public ConsumerBuilder.StreamOptions stream() {
        return this.streamOptions;
    }

    @Override
    public ConsumerBuilder subscriptionListener(ConsumerBuilder.SubscriptionListener subscriptionListener) {
        this.subscriptionListener = subscriptionListener;
        return this;
    }

    ConsumerBuilder.SubscriptionListener subscriptionListener() {
        return this.subscriptionListener;
    }

    AmqpConnection connection() {
        return this.connection;
    }

    String queue() {
        return this.queue;
    }

    boolean directReplyTo() {
        return this.directReplyTo;
    }

    Consumer.MessageHandler messageHandler() {
        return this.messageHandler;
    }

    int initialCredits() {
        return this.initialCredits;
    }

    Map<String, Object> properties() {
        return this.properties;
    }

    List<Resource.StateListener> listeners() {
        return this.listeners;
    }

    Map<String, DescribedType> filters() {
        return this.filters;
    }

    @Override
    public Consumer build() {
        if ((this.queue == null || this.queue.isBlank()) && !this.directReplyTo) {
            throw new IllegalArgumentException("A queue must be specified");
        }
        if (this.messageHandler == null) {
            throw new IllegalArgumentException("Message handler cannot be null");
        }
        return this.connection.createConsumer(this);
    }

    private static void filter(Map<String, DescribedType> filters, String filterName, Object value) {
        filters.put(filterName, AmqpConsumerBuilder.filterValue(filterName, value));
    }

    private static DescribedType filterValue(String filterName, Object value) {
        return new UnknownDescribedType(Symbol.getSymbol(filterName), value);
    }

    static ConsumerBuilder.StreamOptions streamOptions(Map<String, DescribedType> filters) {
        return new DefaultStreamOptions(null, filters);
    }

    private static class DefaultStreamFilterOptions
    implements ConsumerBuilder.StreamFilterOptions {
        private final DefaultStreamOptions streamOptions;
        private final Map<String, DescribedType> filters;

        private DefaultStreamFilterOptions(DefaultStreamOptions streamOptions, Map<String, DescribedType> filters) {
            this.streamOptions = streamOptions;
            this.filters = filters;
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions messageId(Object id) {
            return this.propertyFilter("message-id", id);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions messageId(String id) {
            return this.propertyFilter("message-id", id);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions messageId(long id) {
            return this.propertyFilter("message-id", new UnsignedLong(id));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions messageId(byte[] id) {
            return this.propertyFilter("message-id", new Binary(id));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions messageId(UUID id) {
            return this.propertyFilter("message-id", id);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions correlationId(Object correlationId) {
            return this.propertyFilter("correlation-id", correlationId);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions correlationId(String correlationId) {
            return this.propertyFilter("correlation-id", correlationId);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions correlationId(long correlationId) {
            return this.propertyFilter("correlation-id", new UnsignedLong(correlationId));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions correlationId(byte[] correlationId) {
            return this.propertyFilter("correlation-id", new Binary(correlationId));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions correlationId(UUID correlationId) {
            return this.propertyFilter("correlation-id", correlationId);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions userId(byte[] userId) {
            return this.propertyFilter("user-id", new Binary(userId));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions to(String to) {
            return this.propertyFilter("to", to);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions subject(String subject) {
            return this.propertyFilter("subject", subject);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions replyTo(String replyTo) {
            return this.propertyFilter("reply-to", replyTo);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions contentType(String contentType) {
            return this.propertyFilter("content-type", Symbol.valueOf(contentType));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions contentEncoding(String contentEncoding) {
            return this.propertyFilter("content-encoding", Symbol.valueOf(contentEncoding));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions absoluteExpiryTime(long absoluteExpiryTime) {
            return this.propertyFilter("absolute-expiry-time", new Date(absoluteExpiryTime));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions creationTime(long creationTime) {
            return this.propertyFilter("creation-time", new Date(creationTime));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions groupId(String groupId) {
            return this.propertyFilter("group-id", groupId);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions groupSequence(int groupSequence) {
            return this.propertyFilter("group-sequence", UnsignedInteger.valueOf(groupSequence));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions replyToGroupId(String groupId) {
            return this.propertyFilter("reply-to-group-id", groupId);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions property(String key, boolean value) {
            return this.applicationPropertyFilter(key, value);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions property(String key, byte value) {
            return this.applicationPropertyFilter(key, value);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions property(String key, short value) {
            return this.applicationPropertyFilter(key, value);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions property(String key, int value) {
            return this.applicationPropertyFilter(key, value);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions property(String key, long value) {
            return this.applicationPropertyFilter(key, value);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions propertyUnsigned(String key, byte value) {
            return this.applicationPropertyFilter(key, UnsignedByte.valueOf(value));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions propertyUnsigned(String key, short value) {
            return this.applicationPropertyFilter(key, UnsignedShort.valueOf(value));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions propertyUnsigned(String key, int value) {
            return this.applicationPropertyFilter(key, UnsignedInteger.valueOf(value));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions propertyUnsigned(String key, long value) {
            return this.applicationPropertyFilter(key, UnsignedLong.valueOf(value));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions property(String key, float value) {
            return this.applicationPropertyFilter(key, Float.valueOf(value));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions property(String key, double value) {
            return this.applicationPropertyFilter(key, value);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions propertyDecimal32(String key, BigDecimal value) {
            return this.applicationPropertyFilter(key, new Decimal32(value));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions propertyDecimal64(String key, BigDecimal value) {
            return this.applicationPropertyFilter(key, new Decimal64(value));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions propertyDecimal128(String key, BigDecimal value) {
            return this.applicationPropertyFilter(key, new Decimal128(value));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions property(String key, char value) {
            return this.applicationPropertyFilter(key, Character.valueOf(value));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions propertyTimestamp(String key, long value) {
            return this.applicationPropertyFilter(key, new Date(value));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions property(String key, UUID value) {
            return this.applicationPropertyFilter(key, value);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions property(String key, byte[] value) {
            return this.applicationPropertyFilter(key, new Binary(value));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions property(String key, String value) {
            return this.applicationPropertyFilter(key, value);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions propertySymbol(String key, String value) {
            return this.applicationPropertyFilter(key, Symbol.valueOf(value));
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions sql(String sql) {
            if (!this.streamOptions.builder.connection.sqlFilterExpressionsSupported()) {
                throw new IllegalArgumentException("AMQP SQL filter expressions requires at least RabbitMQ 4.2.0");
            }
            this.filters.put("sql-filter", AmqpConsumerBuilder.filterValue("amqp:sql-filter", sql));
            return this;
        }

        @Override
        public ConsumerBuilder.StreamOptions stream() {
            return this.streamOptions;
        }

        private ConsumerBuilder.StreamFilterOptions propertyFilter(String propertyKey, Object propertyValue) {
            Map<Symbol, Object> filter = this.filter("amqp:properties-filter");
            filter.put(Symbol.valueOf(propertyKey), propertyValue);
            return this;
        }

        private ConsumerBuilder.StreamFilterOptions applicationPropertyFilter(String propertyKey, Object propertyValue) {
            Map<String, Object> filter = this.filter("amqp:application-properties-filter");
            filter.put(propertyKey, propertyValue);
            return this;
        }

        private <K> Map<K, Object> filter(String filterName) {
            DescribedType type = this.filters.computeIfAbsent(filterName, fName -> AmqpConsumerBuilder.filterValue(fName, new LinkedHashMap()));
            return (Map)type.getDescribed();
        }
    }

    private static class DefaultStreamOptions
    implements ConsumerBuilder.StreamOptions {
        private final Map<String, DescribedType> filters;
        private final AmqpConsumerBuilder builder;
        private final ConsumerBuilder.StreamFilterOptions filterOptions;

        private DefaultStreamOptions(AmqpConsumerBuilder builder, Map<String, DescribedType> filters) {
            this.builder = builder;
            this.filters = filters;
            this.filterOptions = new DefaultStreamFilterOptions(this, filters);
        }

        @Override
        public ConsumerBuilder.StreamOptions offset(long offset) {
            return this.filter("rabbitmq:stream-offset-spec", offset);
        }

        @Override
        public ConsumerBuilder.StreamOptions offset(Instant timestamp) {
            Assert.notNull(timestamp, "Timestamp offset");
            return this.offsetSpecification(Date.from(timestamp));
        }

        @Override
        public ConsumerBuilder.StreamOptions offset(ConsumerBuilder.StreamOffsetSpecification specification) {
            Assert.notNull((Object)specification, "Offset specification");
            return this.offsetSpecification(specification.name().toLowerCase(Locale.ENGLISH));
        }

        @Override
        public ConsumerBuilder.StreamOptions offset(String interval) {
            Assert.notNull(interval, "Interval offset");
            if (!Utils.validateMaxAge(interval)) {
                throw new IllegalArgumentException("Invalid value for interval: " + interval + ". Valid examples are: 1Y, 7D, 10m. See https://www.rabbitmq.com/docs/streams#retention.");
            }
            return this.offsetSpecification(interval);
        }

        @Override
        public ConsumerBuilder.StreamOptions filterValues(String ... values) {
            if (values == null || values.length == 0) {
                throw new IllegalArgumentException("At least one stream filter value must specified");
            }
            return this.filter("rabbitmq:stream-filter", Arrays.asList(values));
        }

        @Override
        public ConsumerBuilder.StreamOptions filterMatchUnfiltered(boolean matchUnfiltered) {
            return this.filter("rabbitmq:stream-match-unfiltered", matchUnfiltered);
        }

        @Override
        public ConsumerBuilder.StreamFilterOptions filter() {
            if (!this.builder.connection.filterExpressionsSupported()) {
                throw new IllegalArgumentException("AMQP filter expressions requires at least RabbitMQ 4.1.0");
            }
            return this.filterOptions;
        }

        @Override
        public ConsumerBuilder builder() {
            return this.builder;
        }

        private ConsumerBuilder.StreamOptions offsetSpecification(Object value) {
            return this.filter("rabbitmq:stream-offset-spec", value);
        }

        private ConsumerBuilder.StreamOptions filter(String key, Object value) {
            AmqpConsumerBuilder.filter(this.filters, key, value);
            return this;
        }
    }
}

