/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.impl.AmqpConnection;
import com.rabbitmq.client.amqp.impl.AmqpConnectionBuilder;
import com.rabbitmq.client.amqp.impl.AmqpEnvironment;
import com.rabbitmq.client.amqp.impl.ConnectionUtils;
import com.rabbitmq.client.amqp.impl.DefaultConnectionSettings;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionManager.class);
    private final AmqpEnvironment environment;
    private final Lock connectionsLock = new ReentrantLock();
    private final Set<AmqpConnection> connections = new HashSet<AmqpConnection>();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    ConnectionManager(AmqpEnvironment environment) {
        this.environment = environment;
    }

    AmqpConnection connection(AmqpConnectionBuilder builder) {
        AmqpConnection connection = null;
        if (((DefaultConnectionSettings.DefaultAffinity)builder.connectionSettings().affinity()).activated() && ((DefaultConnectionSettings.DefaultAffinity)builder.connectionSettings().affinity()).reuse()) {
            ((DefaultConnectionSettings.DefaultAffinity)builder.connectionSettings().affinity()).validate();
            ConnectionUtils.AffinityContext affinity = new ConnectionUtils.AffinityContext(((DefaultConnectionSettings.DefaultAffinity)builder.connectionSettings().affinity()).queue(), ((DefaultConnectionSettings.DefaultAffinity)builder.connectionSettings().affinity()).operation());
            connection = this.doOnConnections((Set<AmqpConnection> conns) -> this.connections.stream().filter(c -> affinity.equals(c.affinity())).findAny().orElse(null));
        }
        if (connection == null) {
            AmqpConnectionBuilder copy = new AmqpConnectionBuilder(this.environment);
            builder.copyTo(copy);
            connection = new AmqpConnection(copy);
        }
        AtomicReference<Object> connectionReference = new AtomicReference<Object>(connection);
        this.doOnConnections((Set<AmqpConnection> conns) -> conns.add((AmqpConnection)connectionReference.get()));
        return connection;
    }

    void remove(AmqpConnection connection) {
        this.doOnConnections((Set<AmqpConnection> conns) -> {
            if (!this.closed.get()) {
                conns.remove(connection);
            }
        });
    }

    void close() {
        if (this.closed.compareAndSet(false, true)) {
            for (AmqpConnection connection : this.connections) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Error while closing connection", (Throwable)e);
                }
            }
            this.connections.clear();
        }
    }

    private void doOnConnections(Consumer<Set<AmqpConnection>> operation) {
        this.connectionsLock.lock();
        try {
            operation.accept(this.connections);
        }
        finally {
            this.connectionsLock.unlock();
        }
    }

    private <T> T doOnConnections(Function<Set<AmqpConnection>, T> operation) {
        this.connectionsLock.lock();
        try {
            T t = operation.apply(this.connections);
            return t;
        }
        finally {
            this.connectionsLock.unlock();
        }
    }
}

