/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.AddressBuilder;
import com.rabbitmq.client.amqp.impl.UriUtils;

abstract class DefaultAddressBuilder<T>
implements AddressBuilder<T> {
    private final T owner;
    private String exchange;
    private String key;
    private String queue;

    DefaultAddressBuilder(T owner) {
        this.owner = owner;
    }

    @Override
    public T exchange(String exchange) {
        if ("".equals(exchange)) {
            throw new IllegalArgumentException("The default exchange is not allowed, use the queue format instead");
        }
        this.exchange = exchange;
        this.queue = null;
        return this.result();
    }

    @Override
    public T key(String key) {
        this.key = key;
        this.queue = null;
        return this.result();
    }

    @Override
    public T queue(String queue) {
        this.queue = queue;
        this.exchange = null;
        this.key = null;
        return this.result();
    }

    String address() {
        if (this.exchange != null) {
            if (this.key != null && !this.key.isEmpty()) {
                return "/exchanges/" + UriUtils.encodePathSegment(this.exchange) + "/" + UriUtils.encodePathSegment(this.key);
            }
            return "/exchanges/" + UriUtils.encodePathSegment(this.exchange);
        }
        if (this.queue != null) {
            return "/queues/" + UriUtils.encodePathSegment(this.queue);
        }
        return null;
    }

    T result() {
        return this.owner;
    }

    void copyTo(AddressBuilder<?> copy) {
        copy.exchange(this.exchange);
        copy.key(this.key);
        copy.queue(this.queue);
    }

    DestinationSpec destination() {
        String ex = null;
        String rk = null;
        if (this.exchange != null) {
            ex = this.exchange;
            ex = "amq.default".equals(ex) ? "" : ex;
            rk = this.key == null ? "" : this.key;
        } else if (this.queue != null) {
            ex = "";
            rk = this.queue;
        }
        return new DestinationSpec(ex, rk);
    }

    static class DestinationSpec {
        private final String exchange;
        private final String routingKey;

        DestinationSpec(String exchange, String routingKey) {
            this.exchange = exchange;
            this.routingKey = routingKey;
        }

        String exchange() {
            return this.exchange;
        }

        String routingKey() {
            return this.routingKey;
        }
    }
}

