/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.Address;
import com.rabbitmq.client.amqp.AddressSelector;
import com.rabbitmq.client.amqp.AmqpException;
import com.rabbitmq.client.amqp.ConnectionSettings;
import com.rabbitmq.client.amqp.CredentialsProvider;
import com.rabbitmq.client.amqp.DefaultUsernamePasswordCredentialsProvider;
import com.rabbitmq.client.amqp.OAuth2Settings;
import com.rabbitmq.client.amqp.UsernamePasswordCredentialsProvider;
import com.rabbitmq.client.amqp.impl.Assert;
import com.rabbitmq.client.amqp.impl.ConnectionUtils;
import com.rabbitmq.client.amqp.impl.TlsUtils;
import com.rabbitmq.client.amqp.oauth2.TokenCredentialsManager;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DefaultConnectionSettings<T>
implements ConnectionSettings<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConnectionSettings.class);
    private static final List<String> SASL_MECHANISMS = List.of("PLAIN", "ANONYMOUS", "EXTERNAL");
    static final String DEFAULT_HOST = "localhost";
    static final int DEFAULT_PORT = 5672;
    static final int DEFAULT_TLS_PORT = 5671;
    static final int DEFAULT_WEB_SOCKET_PORT = 15678;
    static final int DEFAULT_WEB_SOCKET_TLS_PORT = 15677;
    static final String DEFAULT_VIRTUAL_HOST = "/";
    private String host = "localhost";
    private int port = 5672;
    private boolean useWebSocket = false;
    private String webSocketPath = "/ws";
    private CredentialsProvider credentialsProvider;
    private String virtualHost = "/";
    private List<URI> uris = Collections.emptyList();
    private Duration idleTimeout = Duration.ofMillis(60000L);
    private static final Random RANDOM = new Random();
    private AddressSelector addressSelector = addresses -> {
        if (addresses.isEmpty()) {
            throw new IllegalStateException("There should at least one node to connect to");
        }
        if (addresses.size() == 1) {
            return (Address)addresses.get(0);
        }
        return (Address)addresses.get(RANDOM.nextInt(addresses.size()));
    };
    private final List<Address> addresses = new CopyOnWriteArrayList<Address>();
    private String saslMechanism = "ANONYMOUS";
    private final DefaultTlsSettings<T> tlsSettings = new DefaultTlsSettings(this);
    private final DefaultAffinity<T> affinity = new DefaultAffinity(this);
    private final DefaultOAuth2Settings<T> oAuth2Settings = new DefaultOAuth2Settings(this);

    DefaultConnectionSettings() {
    }

    @Override
    public T uri(String uriString) {
        return this.uris(uriString);
    }

    @Override
    public T uris(String ... uris) {
        if (uris == null) {
            throw new IllegalArgumentException("URIs parameter cannot be null");
        }
        this.uris = Arrays.stream(uris).map(DefaultConnectionSettings::toUri).collect(Collectors.toUnmodifiableList());
        boolean tls = this.uris.stream().anyMatch(uri -> uri.getScheme().equalsIgnoreCase("amqps"));
        if (tls) {
            this.tlsSettings.enable();
        }
        return this.toReturn();
    }

    @Override
    public T username(String username) {
        this.credentialsProvider = this.credentialsProvider instanceof UsernamePasswordCredentialsProvider ? new DefaultUsernamePasswordCredentialsProvider(username, ((UsernamePasswordCredentialsProvider)this.credentialsProvider).getPassword()) : new DefaultUsernamePasswordCredentialsProvider(username, null);
        this.saslMechanism = "PLAIN";
        return this.toReturn();
    }

    @Override
    public T password(String password) {
        this.credentialsProvider = this.credentialsProvider instanceof UsernamePasswordCredentialsProvider ? new DefaultUsernamePasswordCredentialsProvider(((UsernamePasswordCredentialsProvider)this.credentialsProvider).getUsername(), password) : new DefaultUsernamePasswordCredentialsProvider(null, password);
        this.saslMechanism = "PLAIN";
        return this.toReturn();
    }

    @Override
    public T host(String host) {
        this.host = host;
        return this.toReturn();
    }

    @Override
    public T port(int port) {
        this.port = port;
        return this.toReturn();
    }

    T useWebSocket(boolean useWebSocket) {
        this.useWebSocket = useWebSocket;
        return this.toReturn();
    }

    @Override
    public T virtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
        return this.toReturn();
    }

    @Override
    public T credentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this.toReturn();
    }

    @Override
    public T idleTimeout(Duration idleTimeout) {
        if (idleTimeout.isNegative()) {
            throw new IllegalArgumentException("Idle timeout cannot be negative");
        }
        this.idleTimeout = idleTimeout;
        return this.toReturn();
    }

    @Override
    public T addressSelector(AddressSelector selector) {
        this.addressSelector = selector;
        return this.toReturn();
    }

    @Override
    public T saslMechanism(String mechanism) {
        if (!SASL_MECHANISMS.contains(mechanism)) {
            throw new IllegalArgumentException(String.format("Unsupported SASL mechanism: '%s'. Supported mechanisms are: %s.", mechanism, SASL_MECHANISMS.stream().map(n -> "'" + n + "'").collect(Collectors.joining(", "))));
        }
        this.saslMechanism = mechanism;
        this.credentialsProvider = null;
        return this.toReturn();
    }

    boolean useWebSocket() {
        return this.useWebSocket;
    }

    String webSocketPath() {
        return this.webSocketPath;
    }

    CredentialsProvider credentialsProvider() {
        return this.credentialsProvider;
    }

    String virtualHost() {
        return this.virtualHost;
    }

    Duration idleTimeout() {
        return this.idleTimeout;
    }

    Address selectAddress(List<Address> addresses) {
        if (addresses == null || addresses.isEmpty()) {
            return this.addressSelector.select(this.addresses);
        }
        return this.addressSelector.select(addresses);
    }

    String saslMechanism() {
        return this.saslMechanism;
    }

    abstract T toReturn();

    boolean tlsEnabled() {
        return this.tlsSettings.enabled();
    }

    DefaultTlsSettings<?> tlsSettings() {
        return this.tlsSettings;
    }

    void copyTo(DefaultConnectionSettings<?> copy) {
        copy.host(this.host);
        copy.port(this.port);
        copy.useWebSocket(this.useWebSocket);
        copy.webSocketPath = this.webSocketPath;
        copy.saslMechanism(this.saslMechanism);
        copy.credentialsProvider(this.credentialsProvider);
        copy.virtualHost(this.virtualHost);
        copy.uris((String[])this.uris.stream().map(URI::toString).toArray(String[]::new));
        copy.addressSelector(this.addressSelector);
        copy.idleTimeout(this.idleTimeout);
        if (this.tlsSettings.enabled()) {
            this.tlsSettings.copyTo((DefaultTlsSettings)copy.tls());
        }
        this.affinity.copyTo(copy.affinity);
        if (this.oAuth2Settings.enabled()) {
            this.oAuth2Settings.copyTo((DefaultOAuth2Settings<?>)copy.oauth2());
        }
    }

    DefaultConnectionSettings<?> consolidate() {
        if (this.uris.isEmpty()) {
            int p = this.port;
            if (this.tlsEnabled() && (this.port == 5672 || this.port == 15678)) {
                p = this.useWebSocket ? 15677 : 5671;
            }
            this.addresses.add(new Address(this.host, p));
        } else {
            String path;
            String userInfo;
            int port;
            URI uri = this.uris.get(0);
            String host = uri.getHost();
            if (host != null) {
                this.host(host);
            }
            if ((port = uri.getPort()) != -1) {
                this.port(port);
            }
            if ((userInfo = uri.getRawUserInfo()) != null) {
                String[] userPassword = userInfo.split(":");
                if (userPassword.length > 2) {
                    throw new IllegalArgumentException("Bad user info in URI " + userInfo);
                }
                this.username(DefaultConnectionSettings.uriDecode(userPassword[0]));
                if (userPassword.length == 2) {
                    this.password(DefaultConnectionSettings.uriDecode(userPassword[1]));
                }
            }
            if ((path = uri.getRawPath()) != null && !path.isEmpty()) {
                if (path.indexOf(47, 1) != -1) {
                    throw new IllegalArgumentException("Multiple segments in path of URI: " + path);
                }
                this.virtualHost(DefaultConnectionSettings.uriDecode(uri.getPath().substring(1)));
            }
            boolean tls = this.tlsEnabled() || this.uris.stream().anyMatch(u -> u.getScheme().equalsIgnoreCase("amqps"));
            int defaultPort = tls ? this.defaultTlsPort() : this.defaultPort();
            List addrs = this.uris.stream().map(uriItem -> new Address(uriItem.getHost() == null ? DEFAULT_HOST : uriItem.getHost(), uriItem.getPort() == -1 ? defaultPort : uriItem.getPort())).collect(Collectors.toList());
            this.addresses.clear();
            this.addresses.addAll(addrs);
        }
        return this;
    }

    private int defaultPort() {
        return this.useWebSocket ? 15678 : 5672;
    }

    private int defaultTlsPort() {
        return this.useWebSocket ? 15677 : 5671;
    }

    @Override
    public ConnectionSettings.TlsSettings<T> tls() {
        this.tlsSettings.enable();
        return this.tlsSettings;
    }

    @Override
    public DefaultAffinity<? extends T> affinity() {
        return this.affinity;
    }

    @Override
    public DefaultOAuth2Settings<? extends T> oauth2() {
        return this.oAuth2Settings;
    }

    static DefaultConnectionSettings<?> instance() {
        return new DefaultConnectionSettings<Object>(){

            @Override
            Object toReturn() {
                return null;
            }
        };
    }

    private static URI toUri(String uriString) {
        try {
            URI uri = new URI(uriString);
            if (!"amqp".equalsIgnoreCase(uri.getScheme()) && !"amqps".equalsIgnoreCase(uri.getScheme())) {
                throw new IllegalArgumentException("Wrong scheme in AMQP URI: " + uri.getScheme() + ". Should be amqp or amqps");
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + uriString, e);
        }
    }

    private static String uriDecode(String s) {
        try {
            return URLDecoder.decode(s.replace("+", "%2B"), "US-ASCII");
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static class DefaultOAuthTlsSettings<T>
    implements OAuth2Settings.TlsSettings<T> {
        private final OAuth2Settings<T> oAuth2Settings;
        private SSLContext sslContext;
        private boolean enabled = false;

        DefaultOAuthTlsSettings(OAuth2Settings<T> oAuth2Settings) {
            this.oAuth2Settings = oAuth2Settings;
        }

        @Override
        public OAuth2Settings.TlsSettings<T> sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        @Override
        public OAuth2Settings<T> oauth2() {
            return this.oAuth2Settings;
        }

        void enable() {
            this.enabled = true;
        }

        boolean enabled() {
            return this.enabled;
        }

        SSLContext sslContext() {
            return this.sslContext;
        }

        void copyTo(DefaultOAuthTlsSettings<?> copy) {
            copy.enabled = this.enabled;
            copy.sslContext(this.sslContext);
        }
    }

    static class DefaultOAuth2Settings<T>
    implements OAuth2Settings<T> {
        private final DefaultConnectionSettings<T> connectionSettings;
        private final DefaultOAuthTlsSettings<T> tls = new DefaultOAuthTlsSettings(this);
        private final Map<String, String> parameters = new HashMap<String, String>();
        private String tokenEndpointUri;
        private String clientId;
        private String clientSecret;
        private String grantType = "client_credentials";
        private boolean shared = true;
        private Function<Instant, Duration> refreshDelayStrategy = TokenCredentialsManager.DEFAULT_REFRESH_DELAY_STRATEGY;

        DefaultOAuth2Settings(DefaultConnectionSettings<T> connectionSettings) {
            this.connectionSettings = connectionSettings;
        }

        @Override
        public OAuth2Settings<T> tokenEndpointUri(String uri) {
            this.connectionSettings.saslMechanism("PLAIN");
            this.tokenEndpointUri = uri;
            return this;
        }

        @Override
        public OAuth2Settings<T> clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        public OAuth2Settings<T> clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        @Override
        public OAuth2Settings<T> grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        @Override
        public OAuth2Settings<T> parameter(String name, String value) {
            if (value == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, value);
            }
            return this;
        }

        @Override
        public OAuth2Settings<T> shared(boolean shared) {
            this.shared = shared;
            return this;
        }

        DefaultOAuth2Settings<T> refreshDelayStrategy(Function<Instant, Duration> refreshDelayStrategy) {
            this.refreshDelayStrategy = refreshDelayStrategy;
            return this;
        }

        Function<Instant, Duration> refreshDelayStrategy() {
            return this.refreshDelayStrategy;
        }

        @Override
        public DefaultOAuthTlsSettings<? extends T> tls() {
            this.tls.enable();
            return this.tls;
        }

        @Override
        public T connection() {
            return this.connectionSettings.toReturn();
        }

        void copyTo(DefaultOAuth2Settings<?> copy) {
            copy.tokenEndpointUri(this.tokenEndpointUri);
            copy.clientId(this.clientId);
            copy.clientSecret(this.clientSecret);
            copy.grantType(this.grantType);
            copy.shared(this.shared);
            this.parameters.forEach(copy::parameter);
            if (this.tls.enabled()) {
                this.tls.copyTo((DefaultOAuthTlsSettings<?>)copy.tls());
            }
            copy.refreshDelayStrategy(this.refreshDelayStrategy);
        }

        String tokenEndpointUri() {
            return this.tokenEndpointUri;
        }

        String clientId() {
            return this.clientId;
        }

        String clientSecret() {
            return this.clientSecret;
        }

        String grantType() {
            return this.grantType;
        }

        Map<String, String> parameters() {
            return Map.copyOf(this.parameters);
        }

        boolean shared() {
            return this.shared;
        }

        boolean enabled() {
            return this.tokenEndpointUri != null;
        }

        boolean tlsEnabled() {
            return this.tls.enabled();
        }
    }

    static class DefaultAffinity<T>
    implements ConnectionSettings.Affinity<T> {
        private final DefaultConnectionSettings<T> connectionSettings;
        private String queue;
        private ConnectionSettings.Affinity.Operation operation;
        private boolean reuse = false;
        private ConnectionSettings.AffinityStrategy strategy = ConnectionUtils.LEADER_FOR_PUBLISHING_MEMBERS_FOR_CONSUMING_STRATEGY;

        DefaultAffinity(DefaultConnectionSettings<T> connectionSettings) {
            this.connectionSettings = connectionSettings;
        }

        @Override
        public ConnectionSettings.Affinity<T> queue(String queue) {
            this.queue = queue;
            return this;
        }

        @Override
        public ConnectionSettings.Affinity<T> operation(ConnectionSettings.Affinity.Operation operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public ConnectionSettings.Affinity<T> reuse(boolean reuse) {
            this.reuse = reuse;
            return this;
        }

        @Override
        public ConnectionSettings.Affinity<T> strategy(ConnectionSettings.AffinityStrategy strategy) {
            Assert.notNull(strategy, "Affinity strategy");
            this.strategy = strategy;
            return this;
        }

        @Override
        public T connection() {
            return this.connectionSettings.toReturn();
        }

        String queue() {
            return this.queue;
        }

        ConnectionSettings.Affinity.Operation operation() {
            return this.operation;
        }

        boolean reuse() {
            return this.reuse;
        }

        ConnectionSettings.AffinityStrategy strategy() {
            return this.strategy;
        }

        void copyTo(ConnectionSettings.Affinity<?> copy) {
            copy.queue(this.queue);
            copy.operation(this.operation);
            copy.reuse(this.reuse);
            copy.strategy(this.strategy);
        }

        boolean activated() {
            return this.queue != null || this.operation != null;
        }

        void validate() {
            if (this.queue == null || this.queue.isBlank()) {
                throw new IllegalArgumentException("Connection affinity requires a queue value");
            }
        }
    }

    static class DefaultTlsSettings<T>
    implements ConnectionSettings.TlsSettings<T> {
        private final DefaultConnectionSettings<T> connectionSettings;
        private boolean enabled = false;
        private boolean hostnameVerification = true;
        private SSLContext sslContext;

        private DefaultTlsSettings(DefaultConnectionSettings<T> connectionSettings) {
            this.connectionSettings = connectionSettings;
        }

        @Override
        public ConnectionSettings.TlsSettings<T> hostnameVerification() {
            this.hostnameVerification = true;
            return this;
        }

        @Override
        public ConnectionSettings.TlsSettings<T> hostnameVerification(boolean hostnameVerification) {
            this.hostnameVerification = hostnameVerification;
            return this;
        }

        @Override
        public ConnectionSettings.TlsSettings<T> sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        @Override
        public ConnectionSettings.TlsSettings<T> trustEverything() {
            LOGGER.warn("SECURITY ALERT: this feature trusts every server certificate, effectively disabling peer verification. This is convenient for local development but offers no protection against man-in-the-middle attacks. Please see https://www.rabbitmq.com/docs/ssl to learn more about peer certificate verification.");
            SSLContext context = null;
            for (String protocol : TlsUtils.PROTOCOLS) {
                try {
                    context = SSLContext.getInstance(protocol);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            if (context == null) {
                throw new IllegalStateException("None of the mandatory TLS protocols supported:" + String.join((CharSequence)", ", TlsUtils.PROTOCOLS) + ".");
            }
            try {
                context.init(null, new TrustManager[]{TlsUtils.TRUST_EVERYTHING_TRUST_MANAGER}, null);
            }
            catch (KeyManagementException e) {
                throw new AmqpException(e);
            }
            this.sslContext = context;
            return this;
        }

        @Override
        public T connection() {
            return this.connectionSettings.toReturn();
        }

        void copyTo(DefaultTlsSettings<?> copy) {
            copy.enabled = this.enabled;
            copy.sslContext(this.sslContext);
            copy.hostnameVerification(this.hostnameVerification);
        }

        void enable() {
            this.enabled = true;
        }

        boolean enabled() {
            return this.enabled;
        }

        SSLContext sslContext() {
            return this.sslContext;
        }

        boolean isHostnameVerification() {
            return this.hostnameVerification;
        }
    }
}

