/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.AmqpException;
import com.rabbitmq.qpid.protonj2.client.ErrorCondition;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientConnectionRemotelyClosedException;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientConnectionSecurityException;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientException;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientLinkRemotelyClosedException;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientResourceRemotelyClosedException;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientSessionRemotelyClosedException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;

abstract class ExceptionUtils {
    static final String ERROR_UNAUTHORIZED_ACCESS = "amqp:unauthorized-access";
    static final String ERROR_NOT_FOUND = "amqp:not-found";
    static final String ERROR_RESOURCE_DELETED = "amqp:resource-deleted";

    private ExceptionUtils() {
    }

    static <T> T wrapGet(Future<T> future) throws ClientException {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ClientException) {
                throw (ClientException)e.getCause();
            }
            throw ExceptionUtils.convert(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AmqpException(e);
        }
    }

    static AmqpException convert(Exception e) {
        if (e instanceof AmqpException) {
            return (AmqpException)e;
        }
        if (e instanceof ClientException) {
            return ExceptionUtils.convert((ClientException)e);
        }
        return new AmqpException(e);
    }

    static AmqpException convert(ClientException e) {
        return ExceptionUtils.convert(e, null, new Object[0]);
    }

    static AmqpException convert(ExecutionException e) {
        if (e.getCause() instanceof ClientException) {
            return ExceptionUtils.convert((ClientException)e.getCause());
        }
        return new AmqpException(e.getCause() == null ? e : e.getCause());
    }

    static AmqpException convert(ClientException e, String format, Object ... args) {
        return ExceptionUtils.convert(e, true, format, args);
    }

    private static AmqpException convert(ClientException e, boolean checkCause, String format, Object ... args) {
        AmqpException result;
        String message;
        String string = message = format != null ? String.format(format, args) : null;
        if (e.getCause() instanceof SSLException) {
            result = new AmqpException.AmqpSecurityException(message, e.getCause());
        } else if (e instanceof ClientConnectionSecurityException) {
            result = new AmqpException.AmqpSecurityException(message, e);
        } else if (ExceptionUtils.isNetworkError(e)) {
            result = new AmqpException.AmqpConnectionException(e.getMessage(), e);
        } else if (e instanceof ClientSessionRemotelyClosedException || e instanceof ClientLinkRemotelyClosedException) {
            ErrorCondition errorCondition = ((ClientResourceRemotelyClosedException)e).getErrorCondition();
            result = ExceptionUtils.isUnauthorizedAccess(errorCondition) ? new AmqpException.AmqpSecurityException(e.getMessage(), e) : (ExceptionUtils.isNotFound(errorCondition) ? new AmqpException.AmqpEntityDoesNotExistException(e.getMessage(), e) : (ExceptionUtils.isResourceDeleted(errorCondition) ? new AmqpException.AmqpEntityDoesNotExistException(e.getMessage(), e) : new AmqpException.AmqpResourceClosedException(e.getMessage(), e)));
        } else if (e instanceof ClientConnectionRemotelyClosedException) {
            ErrorCondition errorCondition = ((ClientConnectionRemotelyClosedException)e).getErrorCondition();
            result = ExceptionUtils.isNetworkError(e) || !ExceptionUtils.isUnauthorizedAccess(errorCondition) ? new AmqpException.AmqpConnectionException(e.getMessage(), e) : new AmqpException(e.getMessage(), e);
        } else {
            result = new AmqpException(message, e);
        }
        if (checkCause && AmqpException.class.getName().equals(result.getClass().getName()) && e.getCause() instanceof ClientException) {
            result = ExceptionUtils.convert((ClientException)e.getCause(), false, format, args);
        }
        return result;
    }

    static boolean resourceDeleted(ClientResourceRemotelyClosedException e) {
        return e.getErrorCondition() != null && ERROR_RESOURCE_DELETED.equals(e.getErrorCondition().condition());
    }

    static boolean notFound(ClientResourceRemotelyClosedException e) {
        return e.getErrorCondition() != null && ERROR_NOT_FOUND.equals(e.getErrorCondition().condition());
    }

    static boolean unauthorizedAccess(ClientResourceRemotelyClosedException e) {
        return ExceptionUtils.isUnauthorizedAccess(e.getErrorCondition());
    }

    static boolean noRunningStreamMemberOnNode(Exception e) {
        if (e instanceof AmqpException.AmqpResourceClosedException) {
            String message = e.getMessage();
            if (message == null) {
                return false;
            }
            return message.contains("stream queue") && message.contains("does not have a running replica on the local node") || message.contains("noproc");
        }
        return false;
    }

    private static boolean isUnauthorizedAccess(ErrorCondition errorCondition) {
        return ExceptionUtils.errorConditionEquals(errorCondition, ERROR_UNAUTHORIZED_ACCESS);
    }

    private static boolean isNotFound(ErrorCondition errorCondition) {
        return ExceptionUtils.errorConditionEquals(errorCondition, ERROR_NOT_FOUND);
    }

    private static boolean isResourceDeleted(ErrorCondition errorCondition) {
        return ExceptionUtils.errorConditionEquals(errorCondition, ERROR_RESOURCE_DELETED);
    }

    private static boolean errorConditionEquals(ErrorCondition errorCondition, String expected) {
        return errorCondition != null && expected.equals(errorCondition.condition());
    }

    private static boolean isNetworkError(ClientException e) {
        String message;
        if (e instanceof ClientConnectionRemotelyClosedException && (message = e.getMessage()) != null) {
            return (message = message.toLowerCase()).contains("connection reset") || message.contains("connection refused");
        }
        return false;
    }

    static boolean maybeCloseOnException(Consumer<Throwable> closing, Exception ex) {
        ClientResourceRemotelyClosedException e;
        if ((ex instanceof ClientLinkRemotelyClosedException || ex instanceof ClientSessionRemotelyClosedException) && (ExceptionUtils.notFound(e = (ClientResourceRemotelyClosedException)ex) || ExceptionUtils.resourceDeleted(e) || ExceptionUtils.unauthorizedAccess(e))) {
            closing.accept(ExceptionUtils.convert(e));
            return true;
        }
        return false;
    }
}

