/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.impl.AmqpConsumer;
import com.rabbitmq.client.amqp.impl.ConsumerWorkService;
import com.rabbitmq.client.amqp.impl.WorkPool;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.Executor;

final class WorkPoolConsumerWorkService
implements ConsumerWorkService {
    private static final int MAX_RUNNABLE_BLOCK_SIZE = 256;
    private final Executor executor;
    private final WorkPool<AmqpConsumer, Runnable> workPool;

    WorkPoolConsumerWorkService(Executor executorService, Duration queueingTimeout) {
        this.executor = executorService;
        this.workPool = new WorkPool(queueingTimeout);
    }

    @Override
    public void dispatch(AmqpConsumer consumer, Runnable runnable) {
        if (this.workPool.addWorkItem(consumer, runnable)) {
            this.executor.execute(new WorkPoolRunnable());
        }
    }

    @Override
    public void dispatch(Runnable runnable) {
        this.executor.execute(runnable);
    }

    @Override
    public void register(AmqpConsumer consumer) {
        this.workPool.registerKey(consumer);
    }

    @Override
    public void unregister(AmqpConsumer consumer) {
        this.workPool.unregisterKey(consumer);
    }

    @Override
    public void close() {
        this.workPool.unregisterAllKeys();
    }

    private final class WorkPoolRunnable
    implements Runnable {
        private WorkPoolRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int size = 256;
            ArrayList block = new ArrayList(size);
            try {
                AmqpConsumer key = WorkPoolConsumerWorkService.this.workPool.nextWorkBlock(block, size);
                if (key == null) {
                    return;
                }
                try {
                    for (Runnable runnable : block) {
                        runnable.run();
                    }
                }
                finally {
                    if (WorkPoolConsumerWorkService.this.workPool.finishWorkBlock(key)) {
                        WorkPoolConsumerWorkService.this.executor.execute(new WorkPoolRunnable());
                    }
                }
            }
            catch (RuntimeException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

