/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.oauth2;

import com.rabbitmq.client.amqp.oauth2.OAuth2Exception;
import com.rabbitmq.client.amqp.oauth2.Token;
import com.rabbitmq.client.amqp.oauth2.TokenParser;
import com.rabbitmq.client.amqp.oauth2.TokenRequester;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.Map;
import java.util.function.Consumer;

public final class HttpTokenRequester
implements TokenRequester {
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration CONNECT_TIMEOUT = Duration.ofSeconds(30L);
    private final URI tokenEndpointUri;
    private final String clientId;
    private final String clientSecret;
    private final String grantType;
    private final Map<String, String> parameters;
    private final HttpClient client;
    private final Consumer<HttpRequest.Builder> requestBuilderConsumer;
    private final TokenParser parser;

    public HttpTokenRequester(String tokenEndpointUri, String clientId, String clientSecret, String grantType, Map<String, String> parameters, Consumer<HttpClient.Builder> clientBuilderConsumer, Consumer<HttpRequest.Builder> requestBuilderConsumer, TokenParser parser) {
        try {
            this.tokenEndpointUri = new URI(tokenEndpointUri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Error in URI: " + tokenEndpointUri);
        }
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.grantType = grantType;
        this.parameters = Map.copyOf(parameters);
        this.parser = parser;
        this.requestBuilderConsumer = requestBuilderConsumer == null ? requestBuilder -> requestBuilder.timeout(REQUEST_TIMEOUT).setHeader("authorization", HttpTokenRequester.authorization(this.clientId, this.clientSecret)) : requestBuilderConsumer;
        HttpClient.Builder builder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(CONNECT_TIMEOUT);
        if (clientBuilderConsumer != null) {
            clientBuilderConsumer.accept(builder);
        }
        this.client = builder.build();
    }

    @Override
    public Token request() {
        StringBuilder urlParameters = new StringBuilder();
        HttpTokenRequester.encode(urlParameters, "grant_type", this.grantType);
        for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
            HttpTokenRequester.encode(urlParameters, parameter.getKey(), parameter.getValue());
        }
        byte[] postData = urlParameters.toString().getBytes(StandardCharsets.UTF_8);
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(this.tokenEndpointUri);
        requestBuilder.header("content-type", "application/x-www-form-urlencoded");
        requestBuilder.header("charset", StandardCharsets.UTF_8.name());
        requestBuilder.header("accept", "application/json");
        this.requestBuilderConsumer.accept(requestBuilder);
        HttpRequest request = requestBuilder.POST(HttpRequest.BodyPublishers.ofByteArray(postData)).build();
        try {
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            HttpTokenRequester.checkStatusCode(response.statusCode());
            HttpTokenRequester.checkContentType(response.headers().firstValue("content-type").orElse(null));
            return this.parser.parse(response.body());
        }
        catch (IOException e) {
            throw new OAuth2Exception("Error while retrieving OAuth 2 token", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OAuth2Exception("Error while retrieving OAuth 2 token", e);
        }
    }

    private static String authorization(String username, String password) {
        return "Basic " + HttpTokenRequester.base64(username + ":" + password);
    }

    private static String base64(String in) {
        return Base64.getEncoder().encodeToString(in.getBytes(StandardCharsets.UTF_8));
    }

    private static void encode(StringBuilder builder, String name, String value) {
        if (value != null) {
            if (builder.length() > 0) {
                builder.append("&");
            }
            builder.append(HttpTokenRequester.encode(name)).append("=").append(HttpTokenRequester.encode(value));
        }
    }

    private static String encode(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    private static void checkContentType(String contentType) {
        if (contentType == null || !contentType.toLowerCase().contains("json")) {
            throw new OAuth2Exception("HTTP request for token retrieval is not JSON: " + contentType);
        }
    }

    private static void checkStatusCode(int statusCode) {
        if (statusCode != 200) {
            throw new OAuth2Exception("HTTP request for token retrieval did not return 200 status code: " + statusCode);
        }
    }
}

