/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.observation.micrometer;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;

abstract class Utils {
    private static final String EXCHANGE_DELIMITER = "/exchanges/";
    private static final String KEY_DELIMITER = "/";
    private static final String QUEUE_DELIMITER = "/queues/";
    private static final int EXCHANGE_DELIMITER_LENGTH = "/exchanges/".length();
    private static final int KEY_DELIMITER_LENGTH = "/".length();
    private static final int QUEUE_DELIMITER_LENGTH = "/queues/".length();
    private static final String EMPTY_STRING = "";
    private static final int RADIX = 16;

    private Utils() {
    }

    static String[] exchangeRoutingKeyFromTo(String to) {
        String[] exRk = new String[]{null, null};
        if (to != null) {
            if (to.startsWith(QUEUE_DELIMITER)) {
                exRk[0] = EMPTY_STRING;
                exRk[1] = Utils.percentDecode(to.substring(QUEUE_DELIMITER_LENGTH));
            } else if (to.startsWith(EXCHANGE_DELIMITER)) {
                int keyDelimiterIndex = to.indexOf(KEY_DELIMITER, EXCHANGE_DELIMITER_LENGTH);
                exRk[0] = Utils.percentDecode(to.substring(EXCHANGE_DELIMITER_LENGTH, keyDelimiterIndex == -1 ? to.length() : keyDelimiterIndex));
                exRk[1] = Utils.percentDecode(keyDelimiterIndex == -1 ? null : to.substring(keyDelimiterIndex + KEY_DELIMITER_LENGTH));
            }
        }
        return exRk;
    }

    static String annotationKey(String key) {
        return "x-opt-" + key;
    }

    static String percentDecode(CharSequence content) {
        if (content == null) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.allocate(content.length());
        CharBuffer cb = CharBuffer.wrap(content);
        while (cb.hasRemaining()) {
            char c = cb.get();
            if (c == '%' && cb.remaining() >= 2) {
                char uc = cb.get();
                char lc = cb.get();
                int u = Character.digit(uc, 16);
                int l = Character.digit(lc, 16);
                if (u != -1 && l != -1) {
                    bb.put((byte)((u << 4) + l));
                    continue;
                }
                bb.put((byte)37);
                bb.put((byte)uc);
                bb.put((byte)lc);
                continue;
            }
            bb.put((byte)c);
        }
        bb.flip();
        return StandardCharsets.UTF_8.decode(bb).toString();
    }
}

