/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.buffer;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferComponent;
import java.util.Iterator;
import java.util.NoSuchElementException;

public interface ProtonBufferComponentAccessor
extends AutoCloseable {
    @Override
    public void close();

    public ProtonBufferComponent first();

    default public ProtonBufferComponent firstReadable() {
        ProtonBufferComponent current = this.first();
        if (current != null && current.getReadableBytes() == 0) {
            return this.nextReadable();
        }
        return current;
    }

    default public ProtonBufferComponent firstWritable() {
        ProtonBufferComponent current = this.first();
        if (current != null && current.getWritableBytes() == 0) {
            return this.nextWritable();
        }
        return current;
    }

    public ProtonBufferComponent next();

    default public ProtonBufferComponent nextReadable() {
        return ProtonBufferComponentAccessor.nextReadableComponent(this);
    }

    default public ProtonBufferComponent nextWritable() {
        return ProtonBufferComponentAccessor.nextWritableComponent(this);
    }

    default public Iterable<ProtonBufferComponent> components() {
        return new Iterable<ProtonBufferComponent>(){

            @Override
            public Iterator<ProtonBufferComponent> iterator() {
                return ProtonBufferComponentAccessor.this.componentIterator();
            }
        };
    }

    default public Iterable<ProtonBufferComponent> readableComponents() {
        return new Iterable<ProtonBufferComponent>(){

            @Override
            public Iterator<ProtonBufferComponent> iterator() {
                return ProtonBufferComponentAccessor.this.readableComponentIterator();
            }
        };
    }

    default public Iterable<ProtonBufferComponent> writableComponents() {
        return new Iterable<ProtonBufferComponent>(){

            @Override
            public Iterator<ProtonBufferComponent> iterator() {
                return ProtonBufferComponentAccessor.this.writableComponentIterator();
            }
        };
    }

    default public Iterator<ProtonBufferComponent> componentIterator() {
        return new Iterator<ProtonBufferComponent>(){
            private boolean initialized;
            private ProtonBufferComponent next;

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public ProtonBufferComponent next() {
                if (this.next == null && this.initialized) {
                    throw new NoSuchElementException();
                }
                if (!this.initialized) {
                    this.next = ProtonBufferComponentAccessor.this.first();
                    this.initialized = true;
                } else {
                    this.next = ProtonBufferComponentAccessor.this.next();
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                return this.next;
            }
        };
    }

    default public Iterator<ProtonBufferComponent> readableComponentIterator() {
        return new Iterator<ProtonBufferComponent>(){
            private boolean initialized;
            private ProtonBufferComponent next;

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public ProtonBufferComponent next() {
                if (this.next == null && this.initialized) {
                    throw new NoSuchElementException();
                }
                if (!this.initialized) {
                    this.next = ProtonBufferComponentAccessor.this.firstReadable();
                    this.initialized = true;
                } else {
                    this.next = ProtonBufferComponentAccessor.this.nextReadable();
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                return this.next;
            }
        };
    }

    default public Iterator<ProtonBufferComponent> writableComponentIterator() {
        return new Iterator<ProtonBufferComponent>(){
            private boolean initialized;
            private ProtonBufferComponent next;

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public ProtonBufferComponent next() {
                if (this.next == null && this.initialized) {
                    throw new NoSuchElementException();
                }
                if (!this.initialized) {
                    this.next = ProtonBufferComponentAccessor.this.firstWritable();
                    this.initialized = true;
                } else {
                    this.next = ProtonBufferComponentAccessor.this.nextWritable();
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                return this.next;
            }
        };
    }

    private static ProtonBufferComponent nextReadableComponent(ProtonBufferComponentAccessor accessor) {
        ProtonBufferComponent component = accessor.next();
        while (component != null && component.getReadableBytes() == 0) {
            component = accessor.next();
        }
        return component;
    }

    private static ProtonBufferComponent nextWritableComponent(ProtonBufferComponentAccessor accessor) {
        ProtonBufferComponent component = accessor.next();
        while (component != null && component.getWritableBytes() == 0) {
            component = accessor.next();
        }
        return component;
    }
}

