/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client;

import com.rabbitmq.qpid.protonj2.client.DeliveryState;
import com.rabbitmq.qpid.protonj2.client.DistributionMode;
import com.rabbitmq.qpid.protonj2.client.TerminusOptions;
import com.rabbitmq.qpid.protonj2.client.impl.ClientDeliveryState;
import com.rabbitmq.qpid.protonj2.types.DescribedType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class SourceOptions
extends TerminusOptions<SourceOptions>
implements Cloneable {
    private static final DeliveryState.Type[] DEFAULT_OUTCOMES = new DeliveryState.Type[]{DeliveryState.Type.ACCEPTED, DeliveryState.Type.REJECTED, DeliveryState.Type.RELEASED, DeliveryState.Type.MODIFIED};
    public static final ClientDeliveryState DEFAULT_RECEIVER_OUTCOME = new ClientDeliveryState.ClientModified(true, false);
    private DistributionMode distributionMode;
    private DeliveryState defaultOutcome;
    private DeliveryState.Type[] outcomes = DEFAULT_OUTCOMES;
    private Map<String, Object> filters;

    public SourceOptions clone() {
        return this.copyInto(new SourceOptions());
    }

    protected SourceOptions copyInto(SourceOptions other) {
        super.copyInto(other);
        other.distributionMode(this.distributionMode);
        if (this.filters != null) {
            other.filters(new HashMap<String, Object>(this.filters));
        }
        return other;
    }

    public DistributionMode distributionMode() {
        return this.distributionMode;
    }

    public SourceOptions distributionMode(DistributionMode distributionMode) {
        this.distributionMode = distributionMode;
        return this.self();
    }

    public Map<String, Object> filters() {
        return this.filters;
    }

    public SourceOptions filters(Map<String, Object> filters) {
        this.filters = filters;
        return this.self();
    }

    public SourceOptions addFilter(String name, Object descriptor, Object filter) {
        if (this.filters == null) {
            this.filters = new HashMap<String, Object>();
        }
        this.filters.put(name, new FilterDescribedType(descriptor, filter));
        return this.self();
    }

    public DeliveryState defaultOutcome() {
        return this.defaultOutcome;
    }

    public SourceOptions defaultOutcome(DeliveryState defaultOutcome) {
        this.defaultOutcome = defaultOutcome;
        return this.self();
    }

    public DeliveryState.Type[] outcomes() {
        return this.outcomes;
    }

    public SourceOptions outcomes(DeliveryState.Type ... outcomes) {
        this.outcomes = outcomes != null ? Arrays.copyOf(outcomes, outcomes.length) : null;
        return this.self();
    }

    @Override
    SourceOptions self() {
        return this;
    }

    private static class FilterDescribedType
    implements DescribedType {
        private final Object descriptor;
        private final Object described;

        public FilterDescribedType(Object descriptor, Object described) {
            this.descriptor = descriptor;
            this.described = described;
        }

        @Override
        public Object getDescriptor() {
            return this.descriptor;
        }

        @Override
        public Object getDescribed() {
            return this.described;
        }

        public String toString() {
            return "FilterDescribedType{ descriptor:" + String.valueOf(this.descriptor) + ", described:" + String.valueOf(this.described) + " }";
        }

        public int hashCode() {
            return Objects.hash(this.described, this.descriptor);
        }

        public boolean equals(Object target) {
            if (this == target) {
                return true;
            }
            if (target == null) {
                return false;
            }
            if (!(target instanceof DescribedType)) {
                return false;
            }
            DescribedType other = (DescribedType)target;
            return Objects.equals(this.descriptor, other.getDescriptor()) && Objects.equals(this.described, other.getDescribed());
        }
    }
}

