/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client;

import com.rabbitmq.qpid.protonj2.client.LinkOptions;
import com.rabbitmq.qpid.protonj2.engine.DeliveryTagGenerator;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class StreamSenderOptions
extends LinkOptions<StreamSenderOptions>
implements Cloneable {
    public static final int DEFAULT_PENDING_WRITES_BUFFER_SIZE = 0x6400000;
    private long sendTimeout = -1L;
    private int pendingWritesBufferSize = 0x6400000;
    private Supplier<DeliveryTagGenerator> tagGeneratorSupplier;
    public static final int MIN_BUFFER_SIZE_LIMIT = 256;
    private int writeBufferSize;

    public StreamSenderOptions() {
    }

    public StreamSenderOptions clone() {
        return this.copyInto(new StreamSenderOptions());
    }

    public StreamSenderOptions(StreamSenderOptions options) {
        if (options != null) {
            options.copyInto(this);
        }
    }

    protected StreamSenderOptions copyInto(StreamSenderOptions other) {
        super.copyInto(other);
        other.writeBufferSize(this.writeBufferSize);
        other.sendTimeout(this.sendTimeout);
        other.pendingWritesBufferSize(this.pendingWritesBufferSize);
        return other;
    }

    public int writeBufferSize() {
        return this.writeBufferSize;
    }

    public StreamSenderOptions writeBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
        return this;
    }

    public int pendingWritesBufferSize() {
        return this.pendingWritesBufferSize;
    }

    public StreamSenderOptions pendingWritesBufferSize(int pendingWritesBufferSize) {
        this.pendingWritesBufferSize = pendingWritesBufferSize;
        return this;
    }

    public long sendTimeout() {
        return this.sendTimeout;
    }

    public StreamSenderOptions sendTimeout(long sendTimeout) {
        return this.sendTimeout(sendTimeout, TimeUnit.MILLISECONDS);
    }

    public StreamSenderOptions sendTimeout(long timeout, TimeUnit units) {
        this.sendTimeout = units.toMillis(timeout);
        return this;
    }

    public StreamSenderOptions deliveryTagGeneratorSupplier(Supplier<DeliveryTagGenerator> supplier) {
        this.tagGeneratorSupplier = supplier;
        return this;
    }

    public Supplier<DeliveryTagGenerator> deliveryTagGeneratorSupplier() {
        return this.tagGeneratorSupplier;
    }

    @Override
    protected StreamSenderOptions self() {
        return this;
    }
}

