/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client;

import com.rabbitmq.qpid.protonj2.client.DurabilityMode;
import com.rabbitmq.qpid.protonj2.client.ExpiryPolicy;
import com.rabbitmq.qpid.protonj2.types.UnsignedInteger;
import java.util.Arrays;

public abstract class TerminusOptions<E extends TerminusOptions<E>> {
    private DurabilityMode durabilityMode;
    private long timeout = -1L;
    private ExpiryPolicy expiryPolicy;
    private String[] capabilities;

    abstract E self();

    public DurabilityMode durabilityMode() {
        return this.durabilityMode;
    }

    public E durabilityMode(DurabilityMode durabilityMode) {
        this.durabilityMode = durabilityMode;
        return this.self();
    }

    public long timeout() {
        return this.timeout;
    }

    public E timeout(long timeout) {
        if (timeout < 0L || timeout > UnsignedInteger.MAX_VALUE.longValue()) {
            throw new IllegalArgumentException("Timeout value must be in the range of an unsigned integer");
        }
        this.timeout = timeout;
        return this.self();
    }

    public ExpiryPolicy expiryPolicy() {
        return this.expiryPolicy;
    }

    public E expiryPolicy(ExpiryPolicy expiryPolicy) {
        this.expiryPolicy = expiryPolicy;
        return this.self();
    }

    public String[] capabilities() {
        return this.capabilities;
    }

    public E capabilities(String ... capabilities) {
        this.capabilities = capabilities;
        return this.self();
    }

    protected void copyInto(TerminusOptions<E> other) {
        other.durabilityMode(this.durabilityMode);
        other.expiryPolicy(this.expiryPolicy);
        if (this.timeout > 0L) {
            other.timeout(this.timeout);
        }
        if (this.capabilities != null) {
            other.capabilities(Arrays.copyOf(this.capabilities, this.capabilities.length));
        }
    }
}

