/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client.impl;

import com.rabbitmq.qpid.protonj2.client.DeliveryState;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientException;
import com.rabbitmq.qpid.protonj2.client.impl.ClientDeliveryState;
import com.rabbitmq.qpid.protonj2.client.impl.ClientReceiverLinkType;
import com.rabbitmq.qpid.protonj2.engine.IncomingDelivery;
import com.rabbitmq.qpid.protonj2.types.messaging.Accepted;
import com.rabbitmq.qpid.protonj2.types.messaging.Modified;
import com.rabbitmq.qpid.protonj2.types.messaging.Rejected;
import com.rabbitmq.qpid.protonj2.types.messaging.Released;
import com.rabbitmq.qpid.protonj2.types.transport.ErrorCondition;

public abstract class ClientDeliverable<DeliveryType, ReceiverType extends ClientReceiverLinkType> {
    protected final ReceiverType receiver;
    protected final IncomingDelivery delivery;

    ClientDeliverable(ReceiverType receiver, IncomingDelivery delivery) {
        this.receiver = receiver;
        this.delivery = delivery;
        this.delivery.setLinkedResource(this.self());
    }

    protected abstract DeliveryType self();

    IncomingDelivery protonDelivery() {
        return this.delivery;
    }

    public DeliveryType accept() throws ClientException {
        ((ClientReceiverLinkType)this.receiver).disposition(this.delivery, Accepted.getInstance(), true);
        return this.self();
    }

    public DeliveryType release() throws ClientException {
        ((ClientReceiverLinkType)this.receiver).disposition(this.delivery, Released.getInstance(), true);
        return this.self();
    }

    public DeliveryType reject(String condition, String description) throws ClientException {
        ((ClientReceiverLinkType)this.receiver).disposition(this.delivery, new Rejected().setError(new ErrorCondition(condition, description)), true);
        return this.self();
    }

    public DeliveryType modified(boolean deliveryFailed, boolean undeliverableHere) throws ClientException {
        ((ClientReceiverLinkType)this.receiver).disposition(this.delivery, new Modified().setDeliveryFailed(deliveryFailed).setUndeliverableHere(undeliverableHere), true);
        return this.self();
    }

    public DeliveryType disposition(DeliveryState state, boolean settle) throws ClientException {
        ((ClientReceiverLinkType)this.receiver).disposition(this.delivery, ClientDeliveryState.asProtonType(state), settle);
        return this.self();
    }

    public DeliveryType settle() throws ClientException {
        ((ClientReceiverLinkType)this.receiver).disposition(this.delivery, null, true);
        return this.self();
    }

    public DeliveryState state() {
        return ClientDeliveryState.fromProtonType(this.delivery.getState());
    }

    public DeliveryState remoteState() {
        return ClientDeliveryState.fromProtonType(this.delivery.getRemoteState());
    }

    public boolean remoteSettled() {
        return this.delivery.isRemotelySettled();
    }

    public int messageFormat() {
        return this.delivery.getMessageFormat();
    }

    public boolean settled() {
        return this.delivery.isSettled();
    }
}

