/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client.impl;

import com.rabbitmq.qpid.protonj2.client.DeliveryState;
import com.rabbitmq.qpid.protonj2.client.impl.ClientConversionSupport;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.messaging.Accepted;
import com.rabbitmq.qpid.protonj2.types.messaging.Modified;
import com.rabbitmq.qpid.protonj2.types.messaging.Outcome;
import com.rabbitmq.qpid.protonj2.types.messaging.Rejected;
import com.rabbitmq.qpid.protonj2.types.messaging.Released;
import com.rabbitmq.qpid.protonj2.types.transactions.TransactionalState;
import com.rabbitmq.qpid.protonj2.types.transport.ErrorCondition;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class ClientDeliveryState
implements DeliveryState {
    abstract com.rabbitmq.qpid.protonj2.types.transport.DeliveryState getProtonDeliveryState();

    static DeliveryState fromProtonType(Outcome outcome) {
        if (outcome == null) {
            return null;
        }
        if (outcome instanceof Accepted) {
            return ClientAccepted.getInstance();
        }
        if (outcome instanceof Released) {
            return ClientReleased.getInstance();
        }
        if (outcome instanceof Rejected) {
            return ClientRejected.fromProtonType((Rejected)outcome);
        }
        if (outcome instanceof Modified) {
            return ClientModified.fromProtonType((Modified)outcome);
        }
        throw new IllegalArgumentException("Cannot map to unknown Proton Outcome to a DeliveryStateType: " + String.valueOf(outcome));
    }

    static DeliveryState fromProtonType(com.rabbitmq.qpid.protonj2.types.transport.DeliveryState state) {
        if (state == null) {
            return null;
        }
        switch (state.getType()) {
            case Accepted: {
                return ClientAccepted.getInstance();
            }
            case Released: {
                return ClientReleased.getInstance();
            }
            case Rejected: {
                return ClientRejected.fromProtonType((Rejected)state);
            }
            case Modified: {
                return ClientModified.fromProtonType((Modified)state);
            }
            case Transactional: {
                return ClientTransactional.fromProtonType((TransactionalState)state);
            }
        }
        throw new IllegalArgumentException("Cannot map to unknown Proton Delivery State type");
    }

    static DeliveryState.Type fromOutcomeSymbol(Symbol outcome) {
        if (outcome == null) {
            return null;
        }
        try {
            return DeliveryState.Type.valueOf(outcome.toString().toUpperCase());
        }
        catch (Throwable error) {
            throw new IllegalArgumentException("Cannot map outcome name to unknown Proton DeliveryState.Type");
        }
    }

    static com.rabbitmq.qpid.protonj2.types.transport.DeliveryState asProtonType(DeliveryState state) {
        if (state == null) {
            return null;
        }
        if (state instanceof ClientDeliveryState) {
            return ((ClientDeliveryState)state).getProtonDeliveryState();
        }
        switch (state.getType()) {
            case ACCEPTED: {
                return Accepted.getInstance();
            }
            case RELEASED: {
                return Released.getInstance();
            }
            case REJECTED: {
                return new Rejected();
            }
            case MODIFIED: {
                return new Modified();
            }
            case TRANSACTIONAL: {
                throw new IllegalArgumentException("Cannot manually enlist delivery in AMQP Transactions");
            }
        }
        throw new UnsupportedOperationException("Client does not support the given Delivery State type: " + String.valueOf((Object)state.getType()));
    }

    public static class ClientTransactional
    extends ClientDeliveryState {
        private final TransactionalState txnState = new TransactionalState();

        ClientTransactional(TransactionalState txnState) {
            this.txnState.setOutcome(txnState.getOutcome());
            this.txnState.setTxnId(txnState.getTxnId().copy());
        }

        @Override
        public DeliveryState.Type getType() {
            return DeliveryState.Type.TRANSACTIONAL;
        }

        @Override
        public boolean isAccepted() {
            return this.txnState.getOutcome() instanceof Accepted;
        }

        @Override
        com.rabbitmq.qpid.protonj2.types.transport.DeliveryState getProtonDeliveryState() {
            return this.txnState;
        }

        static ClientTransactional fromProtonType(TransactionalState txnState) {
            return new ClientTransactional(txnState);
        }
    }

    public static class ClientModified
    extends ClientDeliveryState {
        private final Modified modified = new Modified();

        ClientModified(Modified modified) {
            this.modified.setDeliveryFailed(modified.isDeliveryFailed());
            this.modified.setUndeliverableHere(modified.isUndeliverableHere());
            if (modified.getMessageAnnotations() != null) {
                this.modified.setMessageAnnotations(new LinkedHashMap<Symbol, Object>(modified.getMessageAnnotations()));
            }
        }

        public ClientModified(boolean failed, boolean undeliverable) {
            this.modified.setDeliveryFailed(failed);
            this.modified.setUndeliverableHere(undeliverable);
        }

        public ClientModified(boolean failed, boolean undeliverable, Map<String, Object> annotations) {
            this.modified.setDeliveryFailed(failed);
            this.modified.setUndeliverableHere(undeliverable);
            this.modified.setMessageAnnotations(ClientConversionSupport.toSymbolKeyedMap(annotations));
        }

        @Override
        public DeliveryState.Type getType() {
            return DeliveryState.Type.MODIFIED;
        }

        @Override
        com.rabbitmq.qpid.protonj2.types.transport.DeliveryState getProtonDeliveryState() {
            return this.modified;
        }

        static ClientModified fromProtonType(Modified modified) {
            return new ClientModified(modified);
        }
    }

    public static class ClientRejected
    extends ClientDeliveryState {
        private final Rejected rejected = new Rejected();

        ClientRejected(Rejected rejected) {
            if (rejected.getError() != null) {
                rejected.setError(rejected.getError().copy());
            }
        }

        public ClientRejected(String condition, String description) {
            if (condition != null || description != null) {
                this.rejected.setError(new ErrorCondition(Symbol.valueOf(condition), description));
            }
        }

        public ClientRejected(String condition, String description, Map<String, Object> info) {
            if (condition != null || description != null) {
                this.rejected.setError(new ErrorCondition(Symbol.valueOf(condition), description, ClientConversionSupport.toSymbolKeyedMap(info)));
            }
        }

        @Override
        public DeliveryState.Type getType() {
            return DeliveryState.Type.REJECTED;
        }

        @Override
        com.rabbitmq.qpid.protonj2.types.transport.DeliveryState getProtonDeliveryState() {
            return this.rejected;
        }

        static ClientRejected fromProtonType(Rejected rejected) {
            return new ClientRejected(rejected);
        }
    }

    public static class ClientReleased
    extends ClientDeliveryState {
        private static final ClientReleased INSTANCE = new ClientReleased();

        private ClientReleased() {
        }

        @Override
        public DeliveryState.Type getType() {
            return DeliveryState.Type.RELEASED;
        }

        @Override
        com.rabbitmq.qpid.protonj2.types.transport.DeliveryState getProtonDeliveryState() {
            return Released.getInstance();
        }

        public static ClientReleased getInstance() {
            return INSTANCE;
        }
    }

    public static class ClientAccepted
    extends ClientDeliveryState {
        private static final ClientAccepted INSTANCE = new ClientAccepted();

        private ClientAccepted() {
        }

        @Override
        public DeliveryState.Type getType() {
            return DeliveryState.Type.ACCEPTED;
        }

        @Override
        com.rabbitmq.qpid.protonj2.types.transport.DeliveryState getProtonDeliveryState() {
            return Accepted.getInstance();
        }

        public static ClientAccepted getInstance() {
            return INSTANCE;
        }
    }
}

