/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client.impl;

import com.rabbitmq.qpid.protonj2.client.ErrorCondition;
import com.rabbitmq.qpid.protonj2.client.impl.ClientConversionSupport;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public final class ClientErrorCondition
implements ErrorCondition {
    private final com.rabbitmq.qpid.protonj2.types.transport.ErrorCondition error;

    public ClientErrorCondition(ErrorCondition condition) {
        Objects.requireNonNull(condition, "The error condition value cannot be null");
        this.error = new com.rabbitmq.qpid.protonj2.types.transport.ErrorCondition(Symbol.valueOf(condition.condition()), condition.description(), ClientConversionSupport.toSymbolKeyedMap(condition.info()));
    }

    public ClientErrorCondition(String condition, String description, Map<String, Object> info) {
        Objects.requireNonNull(condition, "The error condition value cannot be null");
        this.error = new com.rabbitmq.qpid.protonj2.types.transport.ErrorCondition(Symbol.valueOf(condition), description, ClientConversionSupport.toSymbolKeyedMap(info));
    }

    ClientErrorCondition(com.rabbitmq.qpid.protonj2.types.transport.ErrorCondition condition) {
        Objects.requireNonNull(condition, "The error condition value cannot be null");
        this.error = condition;
    }

    @Override
    public String condition() {
        return this.error.getCondition().toString();
    }

    @Override
    public String description() {
        return this.error.getDescription();
    }

    @Override
    public Map<String, Object> info() {
        return this.error.getInfo() == null ? Collections.EMPTY_MAP : ClientConversionSupport.toStringKeyedMap(this.error.getInfo());
    }

    com.rabbitmq.qpid.protonj2.types.transport.ErrorCondition getProtonErrorCondition() {
        return this.error;
    }

    static com.rabbitmq.qpid.protonj2.types.transport.ErrorCondition asProtonErrorCondition(ErrorCondition condition) {
        if (condition == null) {
            return null;
        }
        if (condition instanceof ClientErrorCondition) {
            return ((ClientErrorCondition)condition).getProtonErrorCondition();
        }
        return new ClientErrorCondition(condition).getProtonErrorCondition();
    }
}

