/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client.impl;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.client.impl.ClientConnection;
import com.rabbitmq.qpid.protonj2.client.impl.ClientExceptionSupport;
import com.rabbitmq.qpid.protonj2.client.transport.Transport;
import com.rabbitmq.qpid.protonj2.client.transport.TransportListener;
import com.rabbitmq.qpid.protonj2.engine.Engine;
import com.rabbitmq.qpid.protonj2.engine.exceptions.EngineStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientTransportListener
implements TransportListener {
    private static final Logger LOG = LoggerFactory.getLogger(ClientTransportListener.class);
    private final Engine engine;
    private final ClientConnection connection;

    ClientTransportListener(ClientConnection connection, Engine engine) {
        this.engine = engine;
        this.connection = connection;
    }

    @Override
    public void transportInitialized(Transport transport) {
        this.engine.configuration().setBufferAllocator(transport.getBufferAllocator());
    }

    @Override
    public void transportConnected(Transport transport) {
        this.engine.start().open();
    }

    @Override
    public void transportRead(ProtonBuffer incoming) {
        try {
            this.connection.autoFlushOff();
            do {
                this.engine.ingest(incoming);
            } while (incoming.isReadable() && this.engine.isWritable());
        }
        catch (EngineStateException e) {
            LOG.warn("Caught problem during incoming data processing: {}", (Object)e.getMessage(), (Object)e);
            this.engine.engineFailed(ClientExceptionSupport.createOrPassthroughFatal(e));
        }
        finally {
            this.connection.autoFlushOn();
        }
    }

    @Override
    public void transportError(Throwable error) {
        if (!this.engine.isShutdown()) {
            LOG.debug("Transport failed: {}", (Object)error.getMessage());
            this.engine.engineFailed(ClientExceptionSupport.convertToConnectionClosedException(error));
        }
    }
}

